/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class ChangeScaleCommand
extends ProjectCommand {
    private Float prevScale;
    private float scale;
    private final ViewScaleFeature scaleFeature;

    public ChangeScaleCommand(@NotNull Process process, float scale) {
        super(process);
        this.scale = scale;
        this.scaleFeature = process.getFeature(ViewScaleFeature.class);
        this.prevScale = this.scaleFeature.getValue();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.CHANGE_MODEL_SCALE.getString();
    }

    public Object execute() {
        this.prevScale = this.scaleFeature.getValue();
        this.scaleFeature.setValue(Float.valueOf(this.scale));
        return null;
    }

    @Override
    public void undo() {
        this.scaleFeature.setValue(this.prevScale);
    }
}

