/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.collections.Sequence;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.RemoveTransitionCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class BoundEventCommand
extends MultipleCommand {
    private final Activity activity;
    private final Event event;

    public BoundEventCommand(@NotNull Event event, @NotNull Activity activity) {
        super(new ProjectObject[0]);
        this.event = event;
        this.activity = activity;
        this.buildMultipleCommand();
    }

    @Override
    public ProjectObject getAffectedObject() {
        return this.event;
    }

    private void buildMultipleCommand() {
        SequenceFlow transition = this.findTransitionToBeRemoved();
        this.addCommand(new RemoveTransitionCommand(transition));
        this.addCommand(new ProjectCommand(new ProjectObject[0]){

            @Override
            public String getName() {
                return ProjectCommandMsg.BOUND_EVENT.getString();
            }

            public Object execute() {
                BoundEventCommand.this.event.toBoundary(BoundEventCommand.this.event.getEventTriggerType(), BoundEventCommand.this.activity);
                return null;
            }

            @Override
            public void undo() {
                BoundEventCommand.this.event.toCatch(BoundEventCommand.this.event.getEventTriggerType());
            }
        });
    }

    @NotNull
    private SequenceFlow findTransitionToBeRemoved() {
        SequenceFlow result = null;
        Sequence<SequenceFlow> flows = this.event.getIncomingSequenceFlows();
        for (SequenceFlow flow : flows) {
            if (!flow.getSource().equals(this.activity)) continue;
            result = flow;
            break;
        }
        assert (result != null) : "Event & Activity should be link by a transition";
        return result;
    }
}

