/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.AddActivityCommand;
import oracle.bpm.project.command.design.AddTransitionCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;

public class AddSubprocessCommand
extends MultipleCommand {
    private Sequence<FlowElement> elements;
    private Subprocess subprocess;

    public AddSubprocessCommand(@NotNull Subprocess subprocess) {
        this(subprocess, (Sequence<FlowElement>)CollectionUtils.emptySequence());
    }

    public AddSubprocessCommand(@NotNull Subprocess subprocess, @NotNull Sequence<FlowElement> elements) {
        super(subprocess);
        this.subprocess = subprocess;
        this.elements = elements;
        this.build();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.CREATE_GROUP.getString();
    }

    private void build() {
        if (this.elements.isEmpty()) {
            this.addCommand(new AddDefaultFlowNodesToSubprocessCommand(this.subprocess));
        } else {
            this.addCommand(new AddFlowElementsToSubprocessCommand(this.subprocess, this.elements));
        }
        this.addCommand(new AddActivityCommand.InnerAddCommand(this.subprocess, this.subprocess.getLocation()));
    }

    private static class AddFlowElementsToSubprocessCommand
    extends ProjectCommand {
        private final List<FlowElement> addedElements = new ArrayList<FlowElement>();
        private final Sequence<FlowElement> elements;
        private final Subprocess subprocess;

        public AddFlowElementsToSubprocessCommand(@NotNull Subprocess subprocess, @NotNull Sequence<FlowElement> elements) {
            super(new ProjectObject[0]);
            this.subprocess = subprocess;
            this.elements = elements;
        }

        public Object execute() throws ExecutionException {
            for (FlowElement element : this.elements) {
                try {
                    this.subprocess.addChild(element);
                }
                catch (ProjectException e) {
                    throw new ExecutionException((Throwable)((Object)e));
                }
                this.addedElements.add(element);
            }
            return null;
        }

        @Override
        public void undo() {
            for (FlowElement elementAdded : this.addedElements) {
                try {
                    this.subprocess.removeChild(elementAdded);
                }
                catch (ProjectException e) {
                    throw new ExecutionException((Throwable)((Object)e));
                }
            }
        }

        @Override
        public String getName() {
            return null;
        }
    }

    private static class AddDefaultFlowNodesToSubprocessCommand
    extends MultipleCommand {
        private final Subprocess subprocess;

        public AddDefaultFlowNodesToSubprocessCommand(@NotNull Subprocess subprocess) {
            super(subprocess);
            this.subprocess = subprocess;
            this.build();
        }

        private void build() {
            Process process = this.subprocess.getProcess();
            Point center = this.subprocess.getLocation();
            StartEvent start = this.subprocess.createStartEvent(this.subprocess.isTriggeredByEvent() ? EventTriggerType.MESSAGE : EventTriggerType.NONE);
            Point startLocation = center.sub(this.subprocess.getWidth() / 3, 0);
            this.addCommand(new AddActivityCommand.InnerAddCommand(start, startLocation));
            EndEvent end = this.subprocess.createEndEvent(EventTriggerType.NONE);
            Point endLocation = center.add(this.subprocess.getWidth() / 3, 0);
            this.addCommand(new AddActivityCommand.InnerAddCommand(end, endLocation));
            SequenceFlow sequenceFlow = this.subprocess.createSequenceFlow(start, end);
            this.addCommand(new AddTransitionCommand(sequenceFlow));
        }
    }
}

