/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.TextAnnotation;

public class AddNoteCommand
extends ProjectCommand {
    private Point location;
    private Process model;
    private TextAnnotation note;

    public AddNoteCommand(TextAnnotation n, int x, int y) {
        super(n);
        this.note = n;
        this.model = this.note.getProcess();
        this.location = new Point(x, y);
    }

    public Object execute() {
        try {
            if (this.note != null) {
                this.note.setLocation(this.location);
                this.model.addChild(this.note);
            }
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        return null;
    }

    @Override
    public void undo() {
        try {
            this.model.removeChild(this.note);
        }
        catch (ProjectException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(ProjectObjectType.NOTE.toString()).getString();
    }

    @Override
    public ProjectObject getAffectedObject() {
        return this.note;
    }
}

