/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.resources;

import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.fojsp.WebContentType;
import oracle.bpm.project.model.resources.Resource;
import oracle.bpm.project.model.resources.ResourcesContainer;
import org.jetbrains.annotations.NotNull;

public class ResourceImpl
extends ResourceObjectImpl
implements Resource.Mutable,
ResourceObject {
    private String name;
    private ResourcesContainer parent;
    private Path path;
    private String sourceDir;
    private WebContentType type;

    public ResourceImpl(Project project, ResourcesContainer parent, String name, WebContentType contentType) {
        super(project);
        this.setId(name);
        this.setName(name);
        this.parent = parent;
        this.type = contentType;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PROJECT_RESOURCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject();
    }

    @Override
    public ResourcesContainer getParent() {
        return this.parent;
    }

    @Override
    public WebContentType getType() {
        return this.type;
    }

    public void setType(WebContentType type) {
        this.type = type;
    }

    @Override
    public String getSourceDir() {
        return this.sourceDir;
    }

    @Override
    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.PROJECT_RESOURCES.create(this.getId());
        }
        return this.path;
    }
}

