/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.dataassociations;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.DataDeclarationComposite;
import oracle.bpm.project.ImmutableDataDeclarationContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.DataDeclarationContainerProvider;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemRef;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSetType;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.project.process.dataassociations.DataAssociationArgument;
import oracle.bpm.project.process.dataassociations.DataAssociationHelper;
import oracle.bpm.project.process.dataassociations.DataAssociationImpl;
import oracle.bpm.project.process.dataassociations.DataAssociationItemImpl;
import oracle.bpm.project.process.dataassociations.DataTransformationImpl;
import org.jetbrains.annotations.NotNull;

public abstract class DataAssociationSetImpl
implements DataAssociationSet {
    private List<DataAssociation> dataAssociations = new ArrayList<DataAssociation>();
    private DataDeclarationContainer dataObjectsContainer;
    private List<DataTransformation> dataTransformations = new ArrayList<DataTransformation>();
    private ExpressionMode expressionMode = ExpressionMode.SIMPLE;
    private DataAssociationSetType type;

    protected DataAssociationSetImpl(@NotNull DataAssociationSetType type, @NotNull DataDeclarationContainer dataObjectsContainer) {
        this.type = type;
        this.dataObjectsContainer = dataObjectsContainer;
    }

    public abstract DataDeclarationContainer getInnerArgumentsProvider();

    @Override
    public DataAssociationItem createDataAssociationItem(@NotNull DataAssociationItemEndpoint endpoint, @NotNull Expression expression, @NotNull Sequence<DataAssociationItemRef> refs) {
        return DataAssociationItemImpl.create(endpoint, expression, this.getContextProvider(endpoint), refs, this.isQueryItem(endpoint));
    }

    @Override
    public DataAssociationItem createDataAssociationItem(@NotNull DataAssociationItemEndpoint endpoint, @NotNull Expression expression) {
        Sequence<DataAssociationItemRef> refs = DataAssociationHelper.getRefsFromExpression(endpoint, expression, this.getContextProvider(endpoint).getDataDeclarationContainer());
        return this.createDataAssociationItem(endpoint, expression, refs);
    }

    @Override
    public DataAssociation createDataAssociation(@NotNull DataAssociationItem source, @NotNull DataAssociationItem target) {
        return DataAssociationImpl.create(this, source, target);
    }

    @Override
    public DataTransformation createDataTransformation(@NotNull Sequence<String> sourceRefs, @NotNull String targetRef, @NotNull String transformationName) {
        return DataTransformationImpl.create(this, sourceRefs, targetRef, transformationName);
    }

    @Override
    public DataAssociationSetType getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull DataAssociationSetType type) {
        this.type = type;
    }

    @Override
    public DataDeclarationContainer getDataObjectsContainer() {
        return this.dataObjectsContainer;
    }

    @Override
    public ExpressionMode getExpressionMode() {
        return this.expressionMode;
    }

    @Override
    public void setExpressionMode(@NotNull ExpressionMode expressionMode) {
        this.expressionMode = expressionMode;
    }

    @Override
    public Sequence<DataDeclaration> getArguments() {
        ArrayList<DataAssociationArgument> result = new ArrayList<DataAssociationArgument>();
        DataDeclarationType type = this.getType().equals((Object)DataAssociationSetType.INPUT) ? DataDeclarationType.DATA_INPUT : DataDeclarationType.DATA_OUTPUT;
        for (DataDeclaration argument : this.getInnerArgumentsProvider().getDeclarations()) {
            DataAssociationArgument fixedArgument = new DataAssociationArgument(argument, type);
            result.add(fixedArgument);
        }
        return CollectionUtils.asSequence(result);
    }

    @Override
    public DataDeclarationContainer getArgumentsContainer() {
        return new ImmutableDataDeclarationContainer(this.getProject()){

            @Override
            public Sequence<DataDeclaration> getLocalDeclarations() {
                return DataAssociationSetImpl.this.getArguments();
            }
        };
    }

    @Override
    public Sequence<DataAssociation> getDataAssociations() {
        return CollectionUtils.asSequence(this.dataAssociations);
    }

    @Override
    public void addDataAssociation(@NotNull DataAssociation dataAssociation) {
        this.dataAssociations.add(dataAssociation);
    }

    @Override
    public void clearDataAssociations() {
        this.dataAssociations.clear();
    }

    @Override
    public void removeDataAssociation(@NotNull DataAssociation dataAssociation) {
        this.dataAssociations.remove(dataAssociation);
    }

    @Override
    public Sequence<DataTransformation> getDataTransformations() {
        return CollectionUtils.asSequence(this.dataTransformations);
    }

    @Override
    public void addDataTransformation(@NotNull DataTransformation dataTransformation) {
        this.dataTransformations.add(dataTransformation);
    }

    @Override
    public void clearDataTransformations() {
        this.dataTransformations.clear();
    }

    @Override
    public void removeDataTransformation(@NotNull DataTransformation dataTransformation) {
        this.dataTransformations.remove(dataTransformation);
    }

    @Override
    public boolean usesTransformations() {
        return !this.dataTransformations.isEmpty();
    }

    @Override
    public DataDeclarationContainerProvider getContextProvider(@NotNull DataAssociationItemEndpoint endpoint) {
        DataDeclarationContainerProvider result = null;
        switch (endpoint) {
            case SOURCE: {
                result = this.getType().equals((Object)DataAssociationSetType.INPUT) ? this.getDataObjectsProvider() : this.getArgumentsProvider();
                break;
            }
            case CUSTOM_SOURCE: {
                if (!this.getType().equals((Object)DataAssociationSetType.OUTPUT)) break;
                ArrayList<DataDeclarationContainerProvider> providers = new ArrayList<DataDeclarationContainerProvider>();
                providers.add(this.getArgumentsProvider());
                providers.add(this.getDataObjectsProvider());
                final DataDeclarationComposite composite = DataDeclarationComposite.createProvidersComposite(this.getProject(), providers);
                result = new DataDeclarationContainerProvider(){

                    @Override
                    public DataDeclarationContainer getDataDeclarationContainer() {
                        return composite;
                    }
                };
                break;
            }
            case TARGET: {
                result = this.getType().equals((Object)DataAssociationSetType.INPUT) ? this.getArgumentsProvider() : this.getDataObjectsProvider();
                break;
            }
            case CUSTOM_TARGET: {
                result = this.getType().equals((Object)DataAssociationSetType.INPUT) ? null : this.getDataObjectsProvider();
            }
        }
        return result;
    }

    private DataDeclarationContainerProvider getDataObjectsProvider() {
        return new DataDeclarationContainerProvider(){

            @Override
            public DataDeclarationContainer getDataDeclarationContainer() {
                return DataAssociationSetImpl.this.getDataObjectsContainer();
            }
        };
    }

    private DataDeclarationContainerProvider getArgumentsProvider() {
        return new DataDeclarationContainerProvider(){

            @Override
            public DataDeclarationContainer getDataDeclarationContainer() {
                return DataAssociationSetImpl.this.getArgumentsContainer();
            }
        };
    }

    private boolean isQueryItem(@NotNull DataAssociationItemEndpoint endpoint) {
        return endpoint.equals((Object)DataAssociationItemEndpoint.TARGET) || endpoint.equals((Object)DataAssociationItemEndpoint.CUSTOM_TARGET) || this.getType().equals((Object)DataAssociationSetType.OUTPUT) && endpoint.equals((Object)DataAssociationItemEndpoint.SOURCE);
    }

    private Project getProject() {
        return this.getInnerArgumentsProvider().getProject();
    }
}

