/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.dataassociations;

import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.NotNull;

class DataAssociationImpl
implements DataAssociation {
    private boolean isCustom;
    private final DataAssociationSet parent;
    private DataAssociationItem source;
    private DataAssociationItem target;

    private DataAssociationImpl(DataAssociationSet parent, DataAssociationItem source, DataAssociationItem target) {
        this.parent = parent;
        this.source = source;
        this.target = target;
        source.setRelatedItem(target);
        target.setRelatedItem(source);
    }

    public static DataAssociation create(DataAssociationSet parent, DataAssociationItem source, DataAssociationItem target) {
        return new DataAssociationImpl(parent, source, target);
    }

    @Override
    public void setSource(@NotNull DataAssociationItem source) {
        this.source = source;
    }

    @Override
    public void setTarget(@NotNull DataAssociationItem target) {
        this.target = target;
    }

    @Override
    public DataAssociationItem getSource() {
        return this.source;
    }

    @Override
    public DataAssociationItem getTarget() {
        return this.target;
    }

    @Override
    public boolean isCustom() {
        return this.isCustom;
    }

    @Override
    public void setIsCustom(boolean custom) {
        this.isCustom = custom;
    }

    public String toString() {
        return this.source.toString() + " -> " + this.target.toString();
    }

    public DataAssociation clone() {
        return new DataAssociationImpl(this.parent, this.source, this.target);
    }
}

