/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process;

import oracle.bpm.project.EventDefinitionImpl;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.features.ErrorEventDefinitionFeature;
import oracle.bpm.project.model.features.IncomingDataAssociationFeature;
import oracle.bpm.project.model.features.OutgoingDataAssociationFeature;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.util.ModelUtils;

public class ErrorEventDefinitionImpl
extends EventDefinitionImpl
implements ErrorEventDefinition {
    private ErrorEventDefinitionFeature error;

    public ErrorEventDefinitionImpl(Event event) {
        super(event);
    }

    @Override
    public String getErrorCode() {
        return this.getErrorFeature().getErrorCode();
    }

    @Override
    public void setError(ErrorObject errorObject) {
        if (ModelUtils.isSameObjectInstance(this.getError(), errorObject)) {
            return;
        }
        this.getErrorFeature().setError(errorObject);
        this.clearDataAssociations();
    }

    @Override
    public void setErrorCode(String errorCode) {
        this.getErrorFeature().setValue(errorCode);
    }

    @Override
    public boolean isCatchAll() {
        return this.getErrorFeature().isCatchAll();
    }

    @Override
    public void setCatchAll(boolean isCatchAll) {
        this.getErrorFeature().setIsCatchAll(isCatchAll);
    }

    @Override
    public ErrorObject getError() {
        return this.getErrorFeature().getError();
    }

    public ErrorEventDefinitionFeature getErrorFeature() {
        if (this.error == null) {
            this.error = this.getEvent().getFeature(ErrorEventDefinitionFeature.class);
        }
        return this.error;
    }

    private void clearDataAssociations() {
        OutgoingDataAssociationFeature outputs;
        Event event = this.getEvent();
        IncomingDataAssociationFeature inputs = event.getFeature(IncomingDataAssociationFeature.class);
        if (inputs != null) {
            inputs.getDataAssociationSet().clearDataAssociations();
        }
        if ((outputs = event.getFeature(OutgoingDataAssociationFeature.class)) != null) {
            outputs.getDataAssociationSet().clearDataAssociations();
        }
    }
}

