/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.presentation.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Time;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.observers.ObservableObjectDelegated;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.presentation.views.ActivityViewAdapter;
import oracle.bpm.project.presentation.views.ApplicationsViewAdapter;
import oracle.bpm.project.presentation.views.AttachmentsViewAdapter;
import oracle.bpm.project.presentation.views.BookmarkViewAdapter;
import oracle.bpm.project.presentation.views.ConsultationsViewAdapter;
import oracle.bpm.project.presentation.views.FolderViewAdapter;
import oracle.bpm.project.presentation.views.HistoryViewAdapter;
import oracle.bpm.project.presentation.views.InstancesViewAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.view.ActivityViewImpl;
import oracle.bpm.view.ApplicationsViewImpl;
import oracle.bpm.view.AttachmentsViewImpl;
import oracle.bpm.view.BookmarkViewImpl;
import oracle.bpm.view.ConsultationsViewImpl;
import oracle.bpm.view.FolderViewImpl;
import oracle.bpm.view.HistoryViewImpl;
import oracle.bpm.view.InstancesViewImpl;
import oracle.bpm.view.ParticipantScope;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.ViewType;
import org.jetbrains.annotations.NotNull;

public abstract class ViewAdapter<T extends ViewImpl>
extends ResourceObjectImpl
implements ResourceObject,
View {
    protected ObservableObjectDelegated observableObject = new ObservableObjectDelegated(this);
    protected T viewImpl;
    private List<View> childrenViews = new ArrayList<View>();
    private ViewType viewType;

    public ViewAdapter(Project project, T viewImpl) {
        super(project);
        this.viewImpl = viewImpl;
    }

    @Override
    @NotNull
    public abstract ProjectObjectType getProjectObjectType();

    public static View create(ViewType viewType, String id, Project project) {
        ViewAdapter result;
        switch (viewType) {
            case APPLICATIONS: {
                result = new ApplicationsViewAdapter(project, new ApplicationsViewImpl(id, null));
                break;
            }
            case INSTANCES: {
                result = new InstancesViewAdapter<InstancesViewImpl>(project, new InstancesViewImpl(id, null));
                break;
            }
            case ACTIVITY_INSTANCES: {
                result = ViewAdapter.createActivityView(project, (ViewImpl)new ActivityViewImpl(id, null, null));
                break;
            }
            case ATTACHMENTS: {
                result = new AttachmentsViewAdapter(project, new AttachmentsViewImpl(id, null));
                break;
            }
            case FOLDER: {
                result = new FolderViewAdapter(project, new FolderViewImpl(id, null));
                break;
            }
            case BOOKMARKS: {
                result = new BookmarkViewAdapter(project, new BookmarkViewImpl(id, null));
                break;
            }
            case CONSULTATIONS: {
                result = new ConsultationsViewAdapter(project, new ConsultationsViewImpl(id, null));
                break;
            }
            case HISTORY: {
                result = new HistoryViewAdapter(project, new HistoryViewImpl(id, null, Time.now(), Time.now()));
                break;
            }
            default: {
                throw new RuntimeException("Invalid ViewType '" + viewType + "'.");
            }
        }
        result.setId(id);
        return result;
    }

    public static ViewAdapter create(ViewImpl view, Project project) {
        ViewAdapter result;
        switch (view.getType()) {
            case APPLICATIONS: {
                result = new ApplicationsViewAdapter(project, (ApplicationsViewImpl)view);
                break;
            }
            case INSTANCES: {
                result = new InstancesViewAdapter<InstancesViewImpl>(project, (InstancesViewImpl)view);
                break;
            }
            case ACTIVITY_INSTANCES: {
                result = ViewAdapter.createActivityView(project, view);
                break;
            }
            case ATTACHMENTS: {
                result = new AttachmentsViewAdapter(project, (AttachmentsViewImpl)view);
                break;
            }
            case FOLDER: {
                result = new FolderViewAdapter(project, (FolderViewImpl)view);
                break;
            }
            case BOOKMARKS: {
                result = new BookmarkViewAdapter(project, (BookmarkViewImpl)view);
                break;
            }
            case CONSULTATIONS: {
                result = new ConsultationsViewAdapter(project, (ConsultationsViewImpl)view);
                break;
            }
            case HISTORY: {
                result = new HistoryViewAdapter(project, (HistoryViewImpl)view);
                break;
            }
            default: {
                throw new RuntimeException("Invalid ViewType '" + view.getType() + "'.");
            }
        }
        result.setId(view.getId());
        return result;
    }

    @Override
    public String getId() {
        return this.viewImpl.getId();
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject();
    }

    @Override
    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    @Override
    public void setCustom(boolean isCustom) {
        this.viewImpl.setCustom(isCustom);
    }

    @Override
    public void setHidden(boolean isHidden) {
        this.viewImpl.setHidden(isHidden);
    }

    @Override
    public void setLabel(String label, Locale locale) {
        this.viewImpl.setLabel(label, locale);
    }

    @Override
    public void assignProcess(String processId) {
        this.viewImpl.assignProcess(processId);
        this.observableObject.fireRelationAdded("process");
    }

    @Override
    public void assignProcesses(String[] processIds) {
        this.viewImpl.assignProcesses(processIds);
    }

    @Override
    public void assignRole(String roleId) {
        this.viewImpl.assignRole(roleId);
    }

    @Override
    public void assignRoles(String[] roleIds) {
        this.viewImpl.assignRoles(roleIds);
    }

    @Override
    public void clearLabels() {
        this.viewImpl.clearLabels();
    }

    @Override
    public String removeLabel(Locale locale) {
        return this.viewImpl.removeLabel(locale);
    }

    @Override
    public void unassignAllProcesses() {
        this.viewImpl.unassignAllProcesses();
    }

    @Override
    public void unassignAllRoles() {
        this.viewImpl.unassignAllRoles();
    }

    @Override
    public void unassignProcess(String processId) {
        this.viewImpl.unassignProcess(processId);
        this.observableObject.fireRelationRemoved("process");
    }

    @Override
    public void unassignRole(String roleId) {
        this.viewImpl.unassignRole(roleId);
    }

    @Override
    public String[] getAssignedProcesses() {
        return this.viewImpl.getAssignedProcesses();
    }

    @Override
    public String[] getAssignedRoles() {
        return this.viewImpl.getAssignedRoles();
    }

    @Override
    public boolean isCustom() {
        return this.viewImpl.isCustom();
    }

    @Override
    public LocaleStringMap getLabels() {
        return this.viewImpl.getLabels();
    }

    @Override
    public boolean isHidden() {
        return this.viewImpl.isHidden();
    }

    @Override
    public String getLabel(Locale locale) {
        return this.viewImpl.getLabel(locale);
    }

    @Override
    public String getOwner() {
        return this.viewImpl.getOwner();
    }

    @Override
    public String getParentId() {
        return this.viewImpl.getParentId();
    }

    public String getPresentation() {
        return this.viewImpl.getPresentation();
    }

    @Override
    public boolean isTransient() {
        return this.viewImpl.isTransient();
    }

    @Override
    public ViewType getType() {
        return this.viewType;
    }

    @Override
    public void setLabels(LocaleStringMap labels) {
        this.viewImpl.setLabels(labels);
    }

    @Override
    public void setLabels(Msg msg) {
        this.viewImpl.setLabels(msg);
    }

    @Override
    public void setLabel(Locale locale, String value) {
        this.viewImpl.setLabel(value, locale);
    }

    @Override
    public void setViewReadOnly(boolean readOnly) {
        this.viewImpl.setReadOnly(readOnly);
    }

    @Override
    public boolean isViewReadOnly() {
        return this.viewImpl.isReadOnly();
    }

    @Override
    public void addRole(String roleId) {
        this.viewImpl.assignRole(roleId);
    }

    @Override
    public List<String> getAssignedProcessesList() {
        return Arrays.asList(this.viewImpl.getAssignedProcesses());
    }

    @Override
    public List getAssignedRolesList() {
        return Arrays.asList(this.viewImpl.getAssignedRoles());
    }

    @Override
    public ParticipantScope getParticipantScope() {
        return null;
    }

    public boolean isCaseSensitiveFilterSelected() {
        return false;
    }

    @Override
    public void removeProcess(String process) {
        this.unassignProcess(process);
    }

    @Override
    public void removeRole(String roleId) {
        this.viewImpl.unassignRole(roleId);
    }

    @Override
    public List<Role> getRoles() {
        return this.project.getViewManager().getAvailableRoles(this.viewImpl.getId());
    }

    @Override
    public String getViewName() {
        return this.viewImpl.getLabel(Locale.getDefault());
    }

    @Override
    public String getTypeString() {
        return this.viewImpl.getType().getString(Locale.getDefault()).toLowerCase();
    }

    public void setPresentation(Presentation presentation) {
        this.viewImpl.setPresentation(presentation.getId());
    }

    @Override
    public boolean containsOneProcess(String[] processes) {
        if (processes == null || processes.length == 0) {
            return false;
        }
        if (processes.length == 1) {
            return true;
        }
        String consolidatedId = processes[0];
        for (String process : processes) {
            if (process.equals(consolidatedId)) continue;
            return false;
        }
        return true;
    }

    public T getViewImpl() {
        return this.viewImpl;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.VIEW.create(this.getId());
        }
        return this.path;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ViewAdapter)) {
            return false;
        }
        ViewAdapter other = (ViewAdapter)obj;
        return Any.equals(this.viewType, other.viewType) && Any.equals(this.viewImpl, other.viewImpl);
    }

    public int hashCode() {
        return (this.viewImpl != null ? this.viewImpl.hashCode() : 27) / (this.viewType != null ? this.viewType.hashCode() : 1);
    }

    @Override
    public List<View> getChildrenViews() {
        return this.childrenViews;
    }

    @Override
    public void addChild(View view) {
        this.childrenViews.add(view);
    }

    @Override
    public void removeChild(View view) {
        this.childrenViews.remove(view);
    }

    @Override
    public void addPropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.observableObject.addPropertyObserver(propertyName, observer);
    }

    @Override
    public void addRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.observableObject.addRelationObserver(relationPropertyName, observer);
    }

    @Override
    public void removePropertyObserver(String propertyName, ObjectPropertyListener observer) {
        this.observableObject.removePropertyObserver(propertyName, observer);
    }

    @Override
    public void removeRelationObserver(String relationPropertyName, ObjectRelationListener observer) {
        this.observableObject.removeRelationObserver(relationPropertyName, observer);
    }

    private static ActivityViewAdapter createActivityView(Project project, ViewImpl view) {
        ActivityViewImpl asActivityViewImpl = (ActivityViewImpl)view;
        ActivityViewAdapter activityView = new ActivityViewAdapter(project, asActivityViewImpl);
        return activityView;
    }
}

