/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.presentation.views;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.project.deployment.ProcessDeploymentUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.presentation.views.ActivityView;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.presentation.views.InstancesViewAdapter;
import oracle.bpm.view.ActivityViewImpl;
import oracle.bpm.view.ViewType;
import org.jetbrains.annotations.NotNull;

public class ActivityViewAdapter
extends InstancesViewAdapter<ActivityViewImpl>
implements ActivityView,
InstancesView,
View,
ProjectObject.Mutable {
    public ActivityViewAdapter(Project project, ActivityViewImpl activityViewImpl) {
        super(project, activityViewImpl);
        this.setViewType(ViewType.ACTIVITY_INSTANCES);
    }

    @Override
    public String getActivityName() {
        FlowNode node = this.getAssignedActivity();
        return node != null ? node.getId() : null;
    }

    @Override
    public FlowNode getAssignedActivity() {
        String[] processDeploymentIds;
        FlowNode auxNode = null;
        for (String processDeploymentId : processDeploymentIds = ((ActivityViewImpl)this.viewImpl).getAssignedProcesses()) {
            FlowNode processNode;
            String processName = ProcessDeploymentUtils.getProcessNameFromDeploymentId(processDeploymentId);
            Process process = this.getProject().findProcess(processName);
            if (process == null || (processNode = process.findNode(((ActivityViewImpl)this.viewImpl).getActivityName())) == null) continue;
            auxNode = processNode;
        }
        FlowNode node = null;
        if (node == null) {
            node = auxNode;
        }
        return node;
    }

    @Override
    public void assignProcess(String processId) {
        ((ActivityViewImpl)this.viewImpl).unassignAllProcesses();
        super.assignProcess(processId);
    }

    @Override
    public List<Role> getRoles() {
        List<Role> result = new ArrayList<Role>();
        if (((ActivityViewImpl)this.viewImpl).getAssignedProcesses().length != 0) {
            result = super.getRoles();
        }
        return result;
    }

    @Override
    public void setActivity(FlowNode selectedNode) {
        if (selectedNode != null) {
            ((ActivityViewImpl)this.viewImpl).setActivityName(selectedNode.getId());
        }
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.VIEW_ACTIVITY_INSTANCES;
    }
}

