/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.presentation.presentations;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.presentation.ColumnAdapter;
import oracle.bpm.resources.Msg;
import oracle.bpm.view.Ordering;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.PresentationType;
import org.jetbrains.annotations.NotNull;

public class PresentationAdapter
extends ResourceObjectImpl
implements Presentation.Mutable,
ResourceObject {
    private Map<String, Msg> customLabels = CollectionFactory.createMap();
    private PresentationImpl presentationImpl;

    public PresentationAdapter(Project project, PresentationImpl presentationImpl) {
        super(project);
        this.presentationImpl = presentationImpl;
        this.setId(presentationImpl.getId());
        this.customLabels.put("default_activity", ProjectMsg.DEFAULT_ACTIVITY_ID);
        this.customLabels.put("default_instances", ProjectMsg.DEFAULT_INSTANCES_ID);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PRESENTATION;
    }

    @Override
    public Presentation.Column[] getColumns() {
        PresentationImpl.Column[] columns = this.presentationImpl.getColumns();
        Presentation.Column[] result = new Presentation.Column[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            PresentationImpl.Column column = columns[i];
            result[i] = new ColumnAdapter(column, this.getProject());
        }
        return result;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject();
    }

    @Override
    public String getOwner() {
        return this.presentationImpl.getOwner();
    }

    @Override
    public boolean isCustom() {
        return this.getOwner().equals("custom");
    }

    @Override
    public String getLabel(Locale locale) {
        if (this.customLabels.containsKey(this.getId())) {
            return this.customLabels.get(this.getId()).getString(locale);
        }
        return this.getId();
    }

    @Override
    public PresentationType getType() {
        return this.presentationImpl.getType();
    }

    @Override
    @NotNull
    public Presentation.Mutable asMutable() {
        return this;
    }

    @Override
    public void setColumns(Presentation.Column[] columns) {
        PresentationImpl.Column[] columnsToAdd = new PresentationImpl.Column[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Presentation.Column column = columns[i];
            columnsToAdd[i] = column.getPresentationImplColumn();
        }
        this.presentationImpl.setColumns(columnsToAdd);
    }

    @Override
    public PresentationImpl getPresentationImpl() {
        return this.presentationImpl;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.PRESENTATION.create(this.getId());
        }
        return this.path;
    }

    @Override
    public Ordering getOrdering() {
        Ordering ordering = this.presentationImpl.getOrdering();
        if (ordering == null) {
            ordering = new Ordering();
            this.setOrdering(ordering);
        }
        return ordering;
    }

    @Override
    public void setOrdering(Ordering ordering) {
        this.presentationImpl.setOrdering(ordering);
    }

    @Override
    public void setColumSize(int rowIndex, int size) {
        Presentation.Column[] selectedColumns = this.getColumns();
        selectedColumns[rowIndex].setSize(size);
        this.setColumns(selectedColumns);
    }

    @Override
    public void addColumn(Presentation.Column column) {
        Presentation.Column[] columnToAdd = new Presentation.Column[]{column};
        Presentation.Column[] selectedColumns = this.getColumns();
        Presentation.Column[] columnsToAdd = new Presentation.Column[selectedColumns.length + 1];
        System.arraycopy(selectedColumns, 0, columnsToAdd, 0, selectedColumns.length);
        columnsToAdd[selectedColumns.length] = column;
        this.setColumns(columnsToAdd);
    }

    @Override
    public void moveRowDown(int row) {
        Presentation.Column[] selectedColumns = this.getColumns();
        Presentation.Column columnToMove = selectedColumns[row];
        selectedColumns[row] = selectedColumns[row + 1];
        selectedColumns[row + 1] = columnToMove;
        this.asMutable().setColumns(selectedColumns);
    }

    @Override
    public void moveRowUp(int row) {
        Presentation.Column[] selectedColumns = this.getColumns();
        Presentation.Column columnToMove = selectedColumns[row];
        selectedColumns[row] = selectedColumns[row - 1];
        selectedColumns[row - 1] = columnToMove;
        this.setColumns(selectedColumns);
    }

    @Override
    public void removeColumn(Presentation.Column column) {
        Presentation.Column[] selectedColumns = this.getColumns();
        List<Presentation.Column> newSelectedColumns = CollectionFactory.createList();
        for (Presentation.Column selectedColumn : selectedColumns) {
            if (selectedColumn.getId().equals(column.getId())) continue;
            newSelectedColumns.add(selectedColumn);
        }
        Presentation.Column[] tmp = new Presentation.Column[newSelectedColumns.size()];
        newSelectedColumns.toArray(tmp);
        this.setColumns(tmp);
    }

    @Override
    public void addSortingColumn(Presentation.Column column) {
        Ordering ordering = this.getOrdering();
        ordering.add(column.getVarDefinition().getId(), true);
        this.presentationImpl.setOrdering(ordering);
    }

    @Override
    public void removeSortingColumn(Presentation.Column column) {
        Ordering ordering = this.getOrdering();
        ordering.removeEntry(column.getVarDefinition().getId());
        this.presentationImpl.setOrdering(ordering);
    }

    @Override
    public void moveSortingColumnDown(int row) {
        Ordering ordering = this.getOrdering();
        ordering.moveEntryDown(row);
        this.presentationImpl.setOrdering(ordering);
    }

    @Override
    public void moveSortingColumnUp(int row) {
        Ordering ordering = this.getOrdering();
        ordering.moveEntryUp(row);
        this.presentationImpl.setOrdering(ordering);
    }

    @Override
    public void updateSortingColumn(Presentation.Column column, boolean ascending) {
        Ordering ordering = this.getOrdering();
        ordering.update(column.getVarDefinition().getId(), ascending);
        this.presentationImpl.setOrdering(ordering);
    }
}

