/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

class RoleDependenciesChecker
implements ProjectObjectChecker<Role> {
    private Organization organization;
    private Project projectDependency;

    RoleDependenciesChecker(Organization organization) {
        this.organization = organization;
    }

    @Override
    public MsgList check(Role role) {
        Role duplicatedRole;
        MsgList messages = MsgList.create();
        Project parentProject = this.getProjectDependency();
        if (parentProject != null && parentProject.isOpen() && (duplicatedRole = parentProject.getOrganization().findRoleById(role.getId())) != null) {
            messages.add(ProjectMsg.DUPLICATED_ROLE(role));
        }
        return messages;
    }

    private Project getProject() {
        return this.getOrganization().getProject();
    }

    private Project getProjectDependency() {
        if (this.projectDependency == null) {
            this.projectDependency = this.getProject().getDependency();
        }
        return this.projectDependency;
    }

    private Organization getOrganization() {
        return this.organization;
    }
}

