/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

class RoleChecker
implements ProjectObjectChecker<Role> {
    private Collection<ProjectObjectChecker<Role>> roleCheckers = new ArrayList<ProjectObjectChecker<Role>>();

    RoleChecker(Organization organization) {
        this.roleCheckers.add(OrganizationCheckerFactory.getParametricRoleChecker());
        this.roleCheckers.add(OrganizationCheckerFactory.getRoleDependenciesChecker(organization));
    }

    @Override
    public MsgList check(Role role) {
        MsgList messages = MsgList.create();
        for (ProjectObjectChecker<Role> roleChecker : this.roleCheckers) {
            messages.addAll(roleChecker.check(role));
        }
        return messages;
    }
}

