/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.AssignableToGroup;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.organization.compiler.checker.CalendarRuleChecker;
import oracle.bpm.project.organization.compiler.checker.CalendarRuleExistenceChecker;
import oracle.bpm.project.organization.compiler.checker.GroupChecker;
import oracle.bpm.project.organization.compiler.checker.GroupsAssignedChecker;
import oracle.bpm.project.organization.compiler.checker.OrganizationalUnitCalendarRuleChecker;
import oracle.bpm.project.organization.compiler.checker.OrganizationalUnitChecker;
import oracle.bpm.project.organization.compiler.checker.OrganizationalUnitExistenceChecker;
import oracle.bpm.project.organization.compiler.checker.ParametricRoleChecker;
import oracle.bpm.project.organization.compiler.checker.ParticipantChecker;
import oracle.bpm.project.organization.compiler.checker.ParticipantOrganizationalUnitChecker;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;
import oracle.bpm.project.organization.compiler.checker.RoleChecker;
import oracle.bpm.project.organization.compiler.checker.RoleDependenciesChecker;
import oracle.bpm.project.organization.compiler.checker.RolesAssignedChecker;
import oracle.bpm.project.organization.compiler.checker.TimeZoneChecker;
import oracle.bpm.project.organization.compiler.checker.WorkWeekChecker;

public final class OrganizationCheckerFactory {
    private OrganizationCheckerFactory() {
    }

    public static ProjectObjectChecker<Role> getRoleChecker(Organization organization) {
        return new RoleChecker(organization);
    }

    public static ProjectObjectChecker<Group> getGroupChecker(Organization organization) {
        return new GroupChecker(organization);
    }

    public static ProjectObjectChecker<Participant> getParticipantChecker(Organization organization) {
        return new ParticipantChecker(organization);
    }

    public static ProjectObjectChecker<Participant> getParticipantOrganizationalUnitChecker(Organization organization) {
        return new ParticipantOrganizationalUnitChecker(organization);
    }

    public static ProjectObjectChecker<OrganizationalUnit> getOrganizationalUnitCalendarRuleChecker(Organization organization) {
        return new OrganizationalUnitCalendarRuleChecker(organization);
    }

    public static ProjectObjectChecker<CalendarRule> getCalendarRuleChecker(Organization organization) {
        return new CalendarRuleChecker();
    }

    public static ProjectObjectChecker<AssignableToGroup> getGroupsAssignedChecker(Organization organization) {
        return new GroupsAssignedChecker(organization);
    }

    public static ProjectObjectChecker<AssignableToRole> getRolesAssignedChecker(Organization organization) {
        return new RolesAssignedChecker(organization);
    }

    public static ProjectObjectChecker<OrganizationalUnit> getOrganizationalUnitExistenceChecker() {
        return new OrganizationalUnitExistenceChecker();
    }

    public static ProjectObjectChecker<CalendarRule> getCalendarRuleExistenceChecker() {
        return new CalendarRuleExistenceChecker();
    }

    public static ProjectObjectChecker<Role> getParametricRoleChecker() {
        return new ParametricRoleChecker();
    }

    public static ProjectObjectChecker<Role> getRoleDependenciesChecker(Organization organization) {
        return new RoleDependenciesChecker(organization);
    }

    public static ProjectObjectChecker<CalendarRule> getTimeZoneChecker() {
        return new TimeZoneChecker();
    }

    public static ProjectObjectChecker<CalendarRule> getWorkWeekChecker() {
        return new WorkWeekChecker();
    }

    public static ProjectObjectChecker<OrganizationalUnit> getOrganizationalUnitChecker(Organization organization) {
        return new OrganizationalUnitChecker(organization);
    }
}

