/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.Time;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.presentation.FilterAttribute;
import oracle.bpm.project.model.presentation.presentations.PresentationManager;
import oracle.bpm.project.model.presentation.views.InstancesView;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.view.Comparison;

public class ViewChecker {
    public static final String AUTOMATIC_HANDLER_ROLE = "AutomaticHandler";

    public static void validateRoles(View view, List<Msg> errors, List<Msg> warnings) {
        Collection<String> nonExistentRoles = view.getProject().getViewManager().getNonexistentRolesIds(view.getId());
        for (String unexistentRole : nonExistentRoles) {
            if (unexistentRole.equals(AUTOMATIC_HANDLER_ROLE)) continue;
            warnings.add(ProjectMsg.INVALID_ROLE_IN_VIEW(unexistentRole, view.getId()));
        }
    }

    public static void validatePresentation(InstancesView view, List<Msg> errors) {
        String presentation = view.getPresentation();
        PresentationManager presentationManager = view.getProject().getPresentationManager();
        if (!presentationManager.containsPresentation(presentation)) {
            errors.add(ProjectMsg.INVALID_PRESENTATION(presentation, view.getId()));
        }
    }

    public static void validateConditions(InstancesView view, List<Msg> messages) {
        List<FilterAttribute> filterAttributes = view.getFilterAttributes();
        Collection<ProjectDataObject> projectvariables = view.getProject().getAllVariables();
        for (FilterAttribute attribute : filterAttributes) {
            if (!projectvariables.contains(attribute.getVariable())) {
                messages.add(ProjectMsg.INVALID_CONDITION(attribute.getVariableId(), view.getId()));
                continue;
            }
            ViewChecker.validateConditionType(view, messages, projectvariables, attribute);
        }
        ViewChecker.validateConditionsValues(view, messages);
    }

    private static void validateConditionType(InstancesView view, List<Msg> messages, Collection<ProjectDataObject> projectvariables, FilterAttribute attribute) {
        ProjectDataObject dataObject = CollectionUtils.findFirst(projectvariables, PredicateUtils.identity(attribute.getVariable()));
        if (attribute.getKind() != dataObject.getType().getKind()) {
            messages.add(ProjectMsg.DIFFERENT_TYPE_CONDITION_VARIABLE(view.getViewName(), dataObject.getDefaultLabel()));
        }
    }

    private static void validateConditionsValues(InstancesView view, List<Msg> messages) {
        List<FilterAttribute> filterAttributes = view.getFilterAttributes();
        for (FilterAttribute attribute : filterAttributes) {
            boolean isBetween = attribute.getComparison().equals((Object)Comparison.BETWEEN) || attribute.getComparison().equals((Object)Comparison.NOT_BETWEEN);
            if (!isBetween) continue;
            ViewChecker.validateBewteeen(attribute, messages);
        }
    }

    private static void validateBewteeen(FilterAttribute attribute, List<Msg> messages) {
        Number[] interval;
        Time[] times;
        ProjectPreferences preferences;
        Locale defaultLanguage;
        ProjectDataObject dataObject = attribute.getVariable();
        String variableLabel = dataObject.getLabel(defaultLanguage = (preferences = dataObject.getProject().getPreferences()).getDefaultLanguage());
        if (variableLabel == null) {
            variableLabel = dataObject.getName();
        }
        if (attribute.getKind() == 6 && (times = (Time[])attribute.getValue())[0].compareTo(times[1]) > 0) {
            messages.add(ProjectMsg.CONDITION_END_GREATER_THAN_BEGIN(variableLabel));
        }
        if (Kind.isNumber(attribute.getKind()) && (interval = (Number[])attribute.getValue())[0].doubleValue() > interval[1].doubleValue()) {
            messages.add(ProjectMsg.CONDITION_END_GREATER_THAN_BEGIN(variableLabel));
        }
    }

    private static void writeMethod(View view) {
        try {
            view.getProject().getWriter().write(view);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

