/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.organization.compiler.PresentationChecker;

@CompilerExtensionMetadata
public class PresentationCompiler
extends AbstractCompilerExtension<Presentation> {
    public PresentationCompiler() {
        super(Presentation.class, CollectionFactory.createListWith(ProjectObjectType.PRESENTATION));
    }

    @Override
    public boolean supports(Presentation object) {
        return true;
    }

    @Override
    public void compile(Presentation presentation, CompilationSession session) throws ProjectException {
        MsgList errors = MsgList.create();
        MsgList warnings = MsgList.create();
        PresentationChecker.validateFormats(presentation, errors, warnings);
        this.reportErrors(errors, presentation);
        this.reportWarnings(warnings, presentation);
    }
}

