/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.view.ColumnFormat;
import oracle.bpm.view.ColumnFormatType;

public class PresentationChecker {
    public static void validateFormats(Presentation presentation, MsgList errors, MsgList warnings) {
        Project project = presentation.getProject();
        Locale defaultLanguage = project.getDefaultLanguage();
        for (Presentation.Column column : presentation.getColumns()) {
            ColumnFormat columnFormat = column.getColumnFormat();
            if (columnFormat == null) continue;
            if (!PresentationChecker.isValidColumnFormat(column)) {
                errors.add(ProjectMsg.INVALID_COLUMN_FORMAT(presentation.getLabel(defaultLanguage), column.getLabel(defaultLanguage)));
                continue;
            }
            ColumnFormatType type = columnFormat.getType();
            if (!type.isCustom() || !Str.isEmpty(columnFormat.getPattern())) continue;
            errors.add(ProjectMsg.EMPTY_COLUMN_FORMAT(presentation.getLabel(defaultLanguage), column.getLabel(defaultLanguage)));
        }
    }

    private static boolean isValidColumnFormat(Presentation.Column column) {
        ColumnFormat columnFormat = column.getColumnFormat();
        ProjectDataObject dataObject = column.getVarDefinition();
        boolean result = true;
        if (columnFormat != null && dataObject != null) {
            ColumnFormatType type = columnFormat.getType();
            if (type.isCustom()) {
                CatalogType typeDescription = dataObject.getType();
                result = typeDescription.isTime() && ColumnFormatType.DATE_CUSTOM.equals((Object)type);
                result |= typeDescription.isNumber() && ColumnFormatType.NUMBER_CUSTOM.equals((Object)type);
            } else {
                CatalogType typeDescription = dataObject.getType();
                List<ColumnFormatType> list = new ArrayList(0);
                if (typeDescription.isNumber()) {
                    list = ColumnFormatType.getNumericalFormatTypes();
                } else if (typeDescription.isTime()) {
                    list = ColumnFormatType.getTimeFormatTypes();
                } else {
                    list = new ArrayList();
                    list.add(ColumnFormatType.DEFAULT);
                }
                result = list.contains(type);
            }
        }
        return result;
    }
}

