/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.Arrays;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

@CompilerExtensionMetadata
public class GroupCompiler
extends AbstractCompilerExtension<Group> {
    public GroupCompiler() {
        super(Group.class, Arrays.asList(ProjectObjectType.ORGANIZATION_GROUP));
    }

    @Override
    public void compile(Group group, CompilationSession session) throws ProjectException {
        ProjectObjectChecker<Group> groupChecker = OrganizationCheckerFactory.getGroupChecker(group.getOrganization());
        super.reportErrors(groupChecker.check(group), group);
    }

    @Override
    public boolean supports(Group group) {
        return true;
    }
}

