/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.TreeMap;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.UndeletableFolderContainerImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.RolesContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.organization.RoleProxy;
import org.jetbrains.annotations.NotNull;

public class RolesContainerImpl
extends UndeletableFolderContainerImpl
implements RolesContainer {
    public RolesContainerImpl(Project project) {
        super(project, project, Path.ROLE.getName());
        this.adaptProjectObject(this.getVFile(Path.ROLE));
        this.setDeletable(false);
    }

    @Override
    public Path getPath() {
        return Path.ROLE;
    }

    @NotNull
    public ProjectObject.Mutable asMutable() {
        return this;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ROLES_CONTAINER;
    }

    @Override
    public Sequence<Role> getDeclaredRoles() {
        return this.getChildrenByType(Role.class);
    }

    @Override
    public Sequence<Role> getRoles() {
        TreeMap<String, Role> result = new TreeMap<String, Role>();
        Project parentProject = this.getProject().getDependency();
        if (parentProject != null && parentProject.isOpen()) {
            Sequence<Role> parentRoles = parentProject.getOrganization().getRoles();
            String projectId = parentProject.getId();
            for (Role role : parentRoles) {
                String id = role.getId();
                result.put(id, new RoleProxy(this.getProject(), projectId, id));
            }
        }
        for (Role role : this.getDeclaredRoles()) {
            result.put(role.getId(), role);
        }
        return CollectionUtils.asSequence(result.values());
    }

    @Override
    public Role findDeclaredRole(String id) {
        return this.findChild(Role.class, id);
    }

    @Override
    public Role findRole(String id) {
        Role role;
        Project parentProject;
        String normalizedId;
        Role result = null;
        if (id != null && (result = this.findDeclaredRole(normalizedId = id)) == null && (parentProject = this.getProject().getDependency()) != null && parentProject.isOpen() && (role = parentProject.getOrganization().findRoleById(normalizedId)) != null) {
            result = new RoleProxy(this.getProject(), parentProject.getId(), role.getId());
        }
        return result;
    }

    @Override
    public Role createRole(String name) throws ProjectException {
        throw new UnsupportedOperationException();
    }
}

