/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.Collection;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.identity.MemberContainerImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import org.jetbrains.annotations.NotNull;

class RoleProxy
extends MemberContainerImpl
implements Comparable<Role>,
Role,
ProjectObject.Mutable {
    private String id;
    private boolean notify = true;
    private String projectId;

    RoleProxy(Project project, String projectId, String id) {
        super(project);
        this.projectId = projectId;
        this.id = id;
    }

    @Override
    public void addCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.addCalendarRuleAssignment(calendarRuleAssignment);
    }

    @Override
    public void addParametricValue(String value) {
        this.addParametricValue(value);
    }

    @Override
    public void addRoleAssignment(RoleAssignment roleAssignment) {
        this.addRoleAssignment(roleAssignment);
    }

    @Override
    public CalendarRuleAssignment.Mutable createCalendarRuleAssignment() {
        return this.createCalendarRuleAssignment();
    }

    @Override
    public void removeAllRoleAssignments() {
        this.removeAllRoleAssignments();
    }

    @Override
    public boolean isProcessOwner() {
        return this.getRole().isProcessOwner();
    }

    @Override
    public void removeCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.removeCalendarRuleAssignment(calendarRuleAssignment);
    }

    @Override
    public void removeParametricValue(String value) {
        this.removeParametricValue(value);
    }

    @Override
    public void removeRoleAssignment(RoleAssignment roleAssignment) {
        this.removeRoleAssignment(roleAssignment);
    }

    @Override
    public void setDescription(String description) {
        this.setDescription(description);
    }

    @Override
    public void setParametric(boolean parametric) {
        this.setParametric(parametric);
    }

    @Override
    public void setParametricValues(Collection<String> values) {
        this.setParametricValues(values);
    }

    @Override
    public AssignableToRole findAssignedObject(String assignedObjectId) {
        return this.getRole().findAssignedObject(assignedObjectId);
    }

    @Override
    public void setName(String name) {
        this.getRole().setName(name);
    }

    @Override
    public String getName() {
        return this.getRole().getName();
    }

    @Override
    public Collection<CalendarRuleAssignment> getCalendarRuleAssignment() {
        return this.getRole().getCalendarRuleAssignment();
    }

    @Override
    public String getDefaultLabel() {
        String result = null;
        try {
            Locale locale = this.getProject().getPreferences().getDefaultLanguage();
            result = this.getRole().getLabel(locale);
            if (result == null || result.trim().length() == 0) {
                result = this.getId();
            }
        }
        catch (RuntimeException e) {
            result = this.getId();
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.getRole().getDescription();
    }

    @Override
    public String getLabel(Locale locale) {
        return this.getRole().getLabel(locale);
    }

    @Override
    public LocaleStringMap getLabelMap() {
        return this.getRole().getLabelMap();
    }

    @Override
    public Collection<String> getParametricValues() {
        return this.getRole().getParametricValues();
    }

    @Override
    public Collection<RoleAssignment> getRoleAssignments() {
        return this.getRole().getRoleAssignments();
    }

    @Override
    public boolean isParametric() {
        return this.getRole().isParametric();
    }

    @Override
    public boolean isReferencedByProcesses() {
        return this.getRole().isReferencedByProcesses();
    }

    @Override
    public boolean isVirtual() {
        return this.getRole().isVirtual();
    }

    @Override
    public Organization getOrganization() {
        return this.getRole().getOrganization();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getRole().getParentObject();
    }

    @Override
    public Path getPath() {
        return this.getRole().getPath();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return this.getRole().getProjectObjectType();
    }

    @Override
    public boolean isActive() {
        return this.getRole().isActive();
    }

    @Override
    public boolean isDescendantOf(ProjectObject projectObject) {
        return this.getRole().isDescendantOf(projectObject);
    }

    @Override
    public boolean isReadOnly() {
        return this.getRole().isReadOnly();
    }

    @Override
    public void replace(ProjectObject newObject) throws ProjectException {
        this.getRole().replace(newObject);
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        this.getRole().visit(visitor);
    }

    @Override
    public void setId(String id) {
        this.setId(id);
    }

    @Override
    public void setReadOnly(boolean value) {
        this.setReadOnly(value);
    }

    public boolean isNotificationsEnabled() {
        return this.notify;
    }

    public void setNotificationsEnabled(boolean b) {
        this.notify = b;
    }

    @Override
    public int compareTo(Role o) {
        return this.getRole().getId().compareTo(o.getId());
    }

    public String getProjectId() {
        return this.projectId;
    }

    public final String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RoleProxy) {
            RoleProxy otherRole = (RoleProxy)o;
            return otherRole.getProjectId().equals(otherRole.getProjectId()) && this.getId().equals(otherRole.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getProjectId().hashCode() << 4 ^ this.getId().hashCode();
    }

    @Override
    public boolean isDefault() {
        return this.getRole().isDefault();
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.setDefault(isDefault);
    }

    @Override
    public void delete() throws ProjectException {
        this.getRole().delete();
    }

    @Override
    public Class getRawClass() {
        return Role.class;
    }

    @Override
    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    private ProjectRepository getProjectRepository() {
        return this.getProject().getLoader().getProjectRepository();
    }

    private Role getRole() {
        Role result = null;
        Project project = this.getProjectRepository().getProject(this.projectId);
        if (project != null && project.isOpen()) {
            result = project.getOrganization().findRoleById(this.id);
        }
        if (result == null) {
            throw new RuntimeException(ProjectModelMsg.PROJECT_OBJECT_NOT_AVAILABLE(ProjectObjectType.ORGANIZATION_ROLE.getMsg().getString(), this.id, this.projectId).getString());
        }
        return result;
    }
}

