/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.identity.MemberContainerImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.CalendarRuleAssignmentImpl;
import oracle.bpm.project.organization.ParametricFeature;
import org.jetbrains.annotations.NotNull;

public class RoleImpl
extends MemberContainerImpl
implements Role,
ProjectObject.Mutable {
    public Exception stacktrace = new Exception();
    private Collection<CalendarRuleAssignment> calendarRuleAssignments;
    private StringFeature description = StringFeature.create("description", ProjectMsg.DESCRIPTION, null, "");
    private LocaleStringMap map;
    private String name;
    private Organization organization;
    private boolean parametric;
    private ParametricFeature parametricFeature = ParametricFeature.create();
    private Collection<String> parametricValues;
    private Collection<RoleAssignment> roleAssignments;

    public RoleImpl(Organization organization, String id, String name) {
        super(organization.getProject());
        this.organization = organization;
        this.parametricValues = new ArrayList<String>();
        this.calendarRuleAssignments = new ArrayList<CalendarRuleAssignment>();
        this.roleAssignments = new ArrayList<RoleAssignment>();
        this.id = id;
        this.name = name;
    }

    @Override
    public void setDescription(String description) {
        String prev = this.description.getValue();
        this.description.setValue(description == null ? "" : description);
        this.events().objectChanged(this.description.getName(), prev, description);
    }

    @Override
    public String getDescription() {
        return this.description.getValue();
    }

    @Override
    public void setParametric(boolean parametric) {
        boolean prev = parametric;
        boolean changed = false;
        if (prev != this.parametric) {
            changed = true;
        }
        this.parametric = parametric;
        if (changed) {
            this.events().objectChanged("IsParametric", prev, this.parametric);
        }
    }

    @Override
    public boolean isParametric() {
        return this.parametric;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ORGANIZATION_ROLE;
    }

    @Override
    public boolean isVirtual() {
        return this.getId().equals("AutomaticHandler");
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.ROLE.create(this.getId());
        }
        return this.path;
    }

    @Override
    public void addParametricValue(String value) {
        this.parametricValues.add(value);
        this.events().objectChanged("parametricValue", null, value);
    }

    @Override
    public void removeParametricValue(String value) {
        this.parametricValues.remove(value);
        this.events().objectChanged("parametricValue", value, null);
    }

    @Override
    public void setParametricValues(Collection<String> values) {
        this.parametricValues = values;
        this.events().objectChanged("parametricValue", null, values);
    }

    @Override
    public Collection<String> getParametricValues() {
        return this.parametricValues;
    }

    @Override
    public Collection<CalendarRuleAssignment> getCalendarRuleAssignment() {
        return this.calendarRuleAssignments;
    }

    @Override
    public void addCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.calendarRuleAssignments.add(calendarRuleAssignment);
        this.events().objectChanged("calendarRuleAssignment", null, calendarRuleAssignment);
    }

    @Override
    public void removeCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.calendarRuleAssignments.remove(calendarRuleAssignment);
        this.events().objectChanged("calendarRuleAssignment", calendarRuleAssignment, null);
    }

    @Override
    public CalendarRuleAssignment.Mutable createCalendarRuleAssignment() {
        CalendarRuleAssignmentImpl result = new CalendarRuleAssignmentImpl();
        result.setRole(this);
        return result;
    }

    @Override
    public void addRoleAssignment(RoleAssignment roleAssignment) {
        if (!this.roleAssignments.contains(roleAssignment)) {
            this.roleAssignments.add(roleAssignment);
        }
    }

    @Override
    public void removeRoleAssignment(RoleAssignment roleAssignment) {
        this.roleAssignments.remove(roleAssignment);
    }

    @Override
    public AssignableToRole findAssignedObject(String assignedObjectId) {
        for (RoleAssignment roleAssignment : this.roleAssignments) {
            if (!roleAssignment.getAssignedObject().getId().equals(assignedObjectId)) continue;
            return roleAssignment.getAssignedObject();
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.events().objectChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<RoleAssignment> getRoleAssignments() {
        return this.roleAssignments;
    }

    @Override
    public int compareTo(Role o) {
        return this.getId().compareTo(o.getId());
    }

    @Override
    public void removeAllRoleAssignments() {
        this.roleAssignments.clear();
    }

    @Override
    public boolean isProcessOwner() {
        return this.getId().equals("ProcessOwner");
    }

    @Override
    public boolean isReferencedByProcesses() {
        Collection<Process> models = this.getProject().getProcesses();
        for (Process model : models) {
            if (model.findLane(this.getId()) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public LocaleStringMap getLabelMap() {
        if (this.map == null) {
            this.map = LocaleStringMap.create();
        }
        return this.map;
    }

    @Override
    public String getDefaultLabel() {
        return this.getString(this.getLabelMap(), this.getName());
    }

    @Override
    public String getLabel(Locale locale) {
        return this.getLabelMap().getString(locale);
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getOrganization();
    }

    @Override
    public Organization getOrganization() {
        return this.organization;
    }
}

