/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectRelation;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;

public class RoleAssignmentImpl
implements ProjectObjectRelation,
RoleAssignment.Mutable {
    private AssignableToRole assignedObject;
    private int category;
    private String parametricValue;
    private int permissions;
    private Role role;
    private String roleId;

    @Override
    public RoleAssignment.Mutable asMutable() {
        return this;
    }

    @Override
    public String getRoleId() {
        return this.role != null ? this.role.getId() : this.roleId;
    }

    @Override
    public void setParametricValue(String parametricValue) {
        this.parametricValue = parametricValue;
    }

    @Override
    public void setRole(Role role) {
        this.role = role;
    }

    @Override
    public void setRole(String roleId) {
        this.roleId = roleId;
    }

    @Override
    public void setCategory(int category) {
        this.category = category;
    }

    @Override
    public String getParametricValue() {
        return this.parametricValue;
    }

    @Override
    public Role getRole() {
        if (this.role == null && this.roleId != null) {
            this.role = this.getOrganization().findRoleById(this.roleId);
        }
        return this.role;
    }

    @Override
    public int getCategory() {
        return this.category;
    }

    @Override
    public AssignableToRole getAssignedObject() {
        return this.assignedObject;
    }

    @Override
    public void setAssignedObject(AssignableToRole assignedObject) {
        this.assignedObject = assignedObject;
    }

    @Override
    public Collection<ProjectObject> getRelation() {
        ArrayList<ProjectObject> relation = new ArrayList<ProjectObject>();
        relation.add(this.getAssignedObject());
        relation.add(this.getRole());
        return relation;
    }

    @Override
    public void addRelation() {
        this.getRole().addRoleAssignment(this);
        ((AssignableToRole.Mutable)this.assignedObject.asMutable()).addRoleAssignment(this);
    }

    @Override
    public void removeRelation() {
        this.getRole().removeRoleAssignment(this);
        ((AssignableToRole.Mutable)this.assignedObject.asMutable()).removeRoleAssignment(this);
    }

    @Override
    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    @Override
    public int getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean match(String roleId, String parametricValue) {
        if (this.getRoleId().equals(roleId)) {
            if (this.parametricValue == null && parametricValue == null) {
                return true;
            }
            return this.parametricValue != null && this.parametricValue.equals(parametricValue);
        }
        return false;
    }

    private Organization getOrganization() {
        return this.getAssignedObject().getOrganization();
    }
}

