/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import oracle.bpm.project.ResourceContainerImpl;
import oracle.bpm.project.model.GroupsContainer;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.organization.GroupImpl;
import org.jetbrains.annotations.NotNull;

public class GroupsContainerImpl
extends ResourceContainerImpl
implements GroupsContainer {
    public GroupsContainerImpl(Project project) {
        super(project);
        this.path = Path.GROUP;
        this.id = this.path.getName();
        this.adaptProjectObject(this.getVFile(Path.GROUP));
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.GROUPS_CONTAINER;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject().getOrganization();
    }

    @Override
    public Group createGroup(String id) throws ProjectException {
        Group.Mutable group = this.createGroup().asMutable();
        group.setId(id);
        return group;
    }

    @Override
    public Group createGroup() {
        return new GroupImpl(this.getProject().getOrganization());
    }
}

