/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectRelation;
import oracle.bpm.project.model.organization.AssignableToGroup;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.GroupAssignment;

public class GroupAssignmentImpl
implements ProjectObjectRelation,
GroupAssignment.Mutable {
    private AssignableToGroup assignedObject;
    private Group group;
    private String groupId;

    @Override
    public GroupAssignment.Mutable asMutable() {
        return this;
    }

    @Override
    public void setGroup(Group group) {
        this.group = group;
    }

    @Override
    public Group getGroup() {
        if (this.groupId != null && this.assignedObject.getOrganization().findGroup(this.groupId) != null) {
            this.group = this.assignedObject.getOrganization().findGroup(this.groupId);
            this.groupId = null;
        }
        return this.group;
    }

    @Override
    public AssignableToGroup getAssignedObject() {
        return this.assignedObject;
    }

    @Override
    public void setAssignedObject(AssignableToGroup assignedObject) {
        this.assignedObject = assignedObject;
    }

    @Override
    public Collection<ProjectObject> getRelation() {
        ArrayList<ProjectObject> relation = new ArrayList<ProjectObject>();
        relation.add(this.getAssignedObject());
        relation.add(this.getGroup());
        return relation;
    }

    @Override
    public void addRelation() {
        this.groupId = null;
        this.group.asMutable().addGroupAssignment(this);
        ((AssignableToGroup.Mutable)this.assignedObject.asMutable()).addGroupAssignment(this);
    }

    @Override
    public void removeRelation() {
        this.group.asMutable().removeGroupAssignment(this);
        ((AssignableToGroup.Mutable)this.assignedObject.asMutable()).removeGroupAssignment(this);
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }
}

