/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogTypeImpl;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.project.model.variables.DefaultValueAssignment;
import oracle.bpm.project.organization.DefaultValueAssignmentImpl;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class BusinessParameterImpl
extends ResourceObjectImpl
implements BusinessParameter.Mutable,
ResourceObject {
    private Object defaultValue;
    private List<DefaultValueAssignment> defaultValueAssignment;
    private TypeDescription typeDescription = TypeFactory.getString();

    public BusinessParameterImpl(Project project) {
        super(project);
        this.defaultValue = Kind.getInitialValue(this.typeDescription.getKind());
        this.defaultValueAssignment = new ArrayList<DefaultValueAssignment>();
    }

    @Override
    @NotNull
    public BusinessParameter.Mutable asMutable() {
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<DefaultValueAssignment> getDefaultValuesAssignment() {
        return this.defaultValueAssignment;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.BUSINESS_PARAMETER.create(this.getId());
        }
        return this.path;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        Object prevDefaultValue = defaultValue;
        this.defaultValue = defaultValue;
        this.events().objectChanged("defaultValue", prevDefaultValue, this.getDefaultValue());
    }

    @Override
    public DefaultValueAssignment.Mutable createDefaultValueAssignment() {
        DefaultValueAssignmentImpl result = new DefaultValueAssignmentImpl();
        result.setBusinessParameter(this);
        return result;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.BUSINESS_PARAMETER;
    }

    @Override
    public void addDefaultValueAssignment(DefaultValueAssignment assignment) {
        this.defaultValueAssignment.add(assignment);
    }

    @Override
    public void removeDefaultValueAssignment(DefaultValueAssignment assignment) {
        this.defaultValueAssignment.remove(assignment);
    }

    @Override
    public CatalogType getTypeDescription() {
        return CatalogTypeImpl.get((TypeRef)this.typeDescription);
    }

    @Override
    public void setTypeDescription(CatalogType typeDescription) {
        TypeDescription prevTypeDesc = this.typeDescription;
        this.typeDescription = typeDescription.getDelegate();
        this.defaultValue = Kind.getInitialValue(this.typeDescription.getKind());
        this.events().objectChanged("typeDescription", prevTypeDesc, this.getTypeDescription());
    }

    @Override
    public int compareTo(BusinessParameter businessParameter) {
        return this.getId().compareTo(businessParameter.getId());
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject().getBusinessParametersContainer();
    }
}

