/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.deployment;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.log.Log;
import oracle.bpm.project.LoadState;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.deployment.EngineImpl;
import oracle.bpm.project.deployment.ReferralImpl;
import oracle.bpm.project.deployment.TopologyImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.deployment.Deployment;
import oracle.bpm.project.model.deployment.Engine;
import oracle.bpm.project.model.deployment.Referral;
import oracle.bpm.project.model.deployment.Topology;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

public class DeploymentImpl
extends ProjectObjectContainerImpl
implements Deployment {
    private Engine engine;
    private LoadState loadState;
    private Project project;
    private Map<String, Referral> referrals;
    private Topology topology;

    public DeploymentImpl(Project project) {
        super(project);
        this.project = project;
        this.referrals = new TreeMap<String, Referral>();
        this.loadState = LoadState.NOT_LOADED;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public synchronized Engine getEngine() {
        if (this.engine == null) {
            this.engine = this.getProject().getDeployment().createEngine();
        }
        return this.engine;
    }

    public LoadState getLoadState() {
        return this.loadState;
    }

    public void setLoadState(LoadState loadState) {
        this.loadState = loadState;
    }

    @Override
    public synchronized Topology getTopology() {
        if (this.topology == null) {
            try {
                List<Topology> loadedTopologies = this.project.getLoader().getAllObjects(Topology.class);
                this.topology = loadedTopologies.size() > 0 ? loadedTopologies.get(0) : new TopologyImpl(this.getProject());
            }
            catch (ProjectException e) {
                Log.logDebug(e);
            }
        }
        return this.topology;
    }

    @Override
    public Collection<Referral> getReferrals() {
        return this.referrals.values();
    }

    @Override
    public Referral createReferral() {
        return new ReferralImpl(this.project);
    }

    @Override
    public Referral createReferral(String referralId) throws ProjectException {
        Referral.Mutable referral = this.createReferral().asMutable();
        referral.setId(referralId);
        return referral;
    }

    @Override
    public void addReferral(Referral referral) throws ProjectException {
        if (this.referrals.containsKey(referral.getId())) {
            // empty if block
        }
        this.referrals.put(referral.getId(), referral);
        this.events().objectChanged();
    }

    @Override
    public void removeReferral(Referral referral) throws ProjectException {
        if (!this.referrals.containsKey(referral.getId())) {
            throw new ProjectException(referral);
        }
        this.referrals.remove(referral.getId());
    }

    @Override
    public Referral removeReferral(String referralId) throws ProjectException {
        if (!this.referrals.containsKey(referralId)) {
            throw new ProjectException(this.project);
        }
        return this.referrals.remove(referralId);
    }

    @Override
    public Referral findReferral(String referralId) {
        return this.referrals.get(referralId);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.DEPLOYMENT;
    }

    @Override
    public void addTopology(Topology tp) {
        this.topology = tp;
    }

    @Override
    public Topology createTopology() {
        return new TopologyImpl(this.project);
    }

    @Override
    public void addEngine(Engine e) {
        this.engine = e;
    }

    @Override
    public Engine createEngine() {
        return new EngineImpl(this.project);
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject();
    }

    @Override
    @NotNull
    public Sequence<? extends ProjectObject> getChildren() {
        Engine e = this.getEngine();
        Sequence<Object> result = e != null ? CollectionUtils.singletonSequence(e) : CollectionUtils.emptySequence();
        return result;
    }
}

