/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.identity;

import oracle.bpm.collections.Sequence;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.identity.ApplicationRoleImpl;
import oracle.bpm.project.identity.GroupImpl;
import oracle.bpm.project.identity.UserImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.identity.ApplicationRole;
import oracle.bpm.project.model.identity.Group;
import oracle.bpm.project.model.identity.Member;
import oracle.bpm.project.model.identity.MemberContainer;
import oracle.bpm.project.model.identity.User;

public abstract class MemberContainerImpl
extends ProjectObjectContainerImpl
implements MemberContainer {
    public MemberContainerImpl(Project project) {
        super(project);
    }

    @Override
    public Sequence<User> getUsers() {
        return this.getChildrenByType(User.class);
    }

    @Override
    public void addMember(Member member) throws ProjectException {
        this.addChild(member);
    }

    @Override
    public void removeMember(Member member) throws ProjectException {
        this.removeChild(member);
    }

    @Override
    public Member findMember(String memberId) {
        return this.findChild(Member.class, memberId);
    }

    @Override
    public Sequence<Member> getMembers() {
        return this.getChildrenByType(Member.class);
    }

    @Override
    public void addUser(User user) throws ProjectException {
        this.addChild(user);
    }

    @Override
    public Sequence<Group> getGroups() {
        return this.getChildrenByType(Group.class);
    }

    @Override
    public void addGroup(Group group) throws ProjectException {
        this.addChild(group);
    }

    @Override
    public Sequence<ApplicationRole> getApplicationRoles() {
        return this.getChildrenByType(ApplicationRole.class);
    }

    @Override
    public void addApplicationRole(ApplicationRole applicationRole) throws ProjectException {
        this.addChild(applicationRole);
    }

    @Override
    public User createUser(String id) throws ProjectException {
        return new UserImpl(id, this);
    }

    @Override
    public Group createGroup(String id) throws ProjectException {
        return new GroupImpl(id, this);
    }

    @Override
    public ApplicationRole createApplicationRole(String id) throws ProjectException {
        return new ApplicationRoleImpl(id, this);
    }

    @Override
    public User findUser(String userId) {
        return this.findChild(User.class, userId);
    }

    @Override
    public Group findGroup(String groupId) {
        return this.findChild(Group.class, groupId);
    }

    @Override
    public ApplicationRole findApplicationRole(String applicationRoleId) {
        return this.findChild(ApplicationRole.class, applicationRoleId);
    }

    @Override
    public void removeUser(User user) throws ProjectException {
        this.removeChild(user);
    }

    @Override
    public void removeGroup(Group group) throws ProjectException {
        this.removeChild(group);
    }

    @Override
    public void removeApplicationRole(ApplicationRole applicationRole) throws ProjectException {
        this.removeChild(applicationRole);
    }
}

