/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.fojsp;

import java.util.Collection;
import java.util.TreeMap;
import oracle.bpm.project.ContainerImpl;
import oracle.bpm.project.fojsp.WebContentImpl;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.fojsp.WebContainer;
import oracle.bpm.project.model.fojsp.WebContent;
import oracle.bpm.project.model.fojsp.WebContentType;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

public class WebContainerImpl
extends ContainerImpl
implements WebContainer.Mutable {
    private Path path;
    private TreeMap<String, WebContent> webContents = new TreeMap();

    public WebContainerImpl(Project project, Container parent, String name) {
        super(project, parent);
        this.setId(name);
    }

    @Override
    @NotNull
    public WebContainer.Mutable asMutable() {
        return this;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.WEB_CONTAINER;
    }

    public void addContainer(WebContainer container) throws ProjectException {
        if (this.findContainer(container.getId()) != null) {
            throw new ProjectException(container);
        }
        this.events().preObjectAdded(container, (ProjectObject)this);
        super.addContainer(container);
        this.events().postObjectAdded(container, (ProjectObject)this);
    }

    @Override
    public WebContainer.Mutable createContainer(String id) throws ProjectException {
        return new WebContainerImpl(this.getProject(), this, id);
    }

    @Override
    public void addWebContent(WebContent webContent) throws ProjectException {
        if (this.findWebContent(webContent) != null) {
            throw new ProjectException(webContent, ProjectMsg.RESOURCE_ALREADY_EXISTS(webContent.getName() + webContent.getType().getFileExtension()));
        }
        this.events().preObjectAdded(webContent, (ProjectObject)this);
        this.webContents.put(webContent.getId() + (Object)((Object)webContent.getType()), webContent);
        this.events().postObjectAdded(webContent, (ProjectObject)this);
    }

    @Override
    public WebContent.Mutable createWebContent(String name, WebContentType type) {
        return new WebContentImpl(this.getProject(), this, name, type);
    }

    @Override
    public void removeWebContent(WebContent webContent) throws ProjectException {
        this.events().preObjectRemoved(webContent, (ProjectObject)this);
        this.webContents.remove(webContent.getId() + (Object)((Object)webContent.getType()));
        this.events().postObjectRemoved(webContent, (ProjectObject)this);
    }

    @Override
    public Collection<WebContent> getWebContents() {
        return this.webContents.values();
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = this.isRoot() && this.getParent().isRoot() ? Path.WEB_ROOT.create(this.getId()) : this.getParent().getPath().create(this.getId());
        }
        return this.path;
    }

    @Override
    public Container findContainer(Path path) {
        return null;
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public WebContent findWebContent(String name, WebContentType contentType) {
        return this.webContents.get(name + (Object)((Object)contentType));
    }

    @Override
    public WebContentType getType() {
        return WebContentType.FOLDER;
    }

    @Override
    public WebContent findWebContent(WebContent webContent) {
        return this.findWebContent(webContent.getName(), webContent.getType());
    }
}

