/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.events;

import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.exception.ProjectException;

public class SafeProjectListener<E extends ProjectObject>
implements ProjectListener<E> {
    protected ProjectListener<E> delegate;

    protected SafeProjectListener(ProjectListener<E> delegate) {
        this.delegate = delegate;
    }

    public static <T extends ProjectObject> ProjectListener<T> create(ProjectListener<T> listener) {
        if (!(listener instanceof SafeProjectListener)) {
            listener = new SafeProjectListener<T>(listener);
        }
        return listener;
    }

    @Override
    public Class<E> getSupportedTypes() {
        return this.delegate.getSupportedTypes();
    }

    @Override
    public void processPreEvents(ProjectEventSet events) throws ProjectException {
        try {
            this.delegate.processPreEvents(events);
        }
        catch (ProjectException e) {
            throw e;
        }
        catch (Throwable unexpected) {
            Log.logSevere(unexpected);
        }
    }

    @Override
    public void processPostEvents(ProjectEventSet events) {
        try {
            this.delegate.processPostEvents(events);
        }
        catch (Throwable unexpected) {
            Log.logSevere(unexpected);
        }
    }

    @Override
    public void preObjectAdded(E object, ProjectObject parent) throws ProjectException {
        try {
            this.delegate.preObjectAdded(object, parent);
        }
        catch (ProjectException e) {
            throw e;
        }
        catch (Throwable unexpected) {
            Log.logSevere(unexpected);
        }
    }

    @Override
    public void preObjectRemoved(E object, ProjectObject parent) throws ProjectException {
        try {
            this.delegate.preObjectRemoved(object, parent);
        }
        catch (ProjectException e) {
            throw e;
        }
        catch (Throwable unexpected) {
            Log.logSevere(unexpected);
        }
    }

    @Override
    public void postObjectAdded(E object, ProjectObject parent) {
        try {
            this.delegate.postObjectAdded(object, parent);
        }
        catch (Throwable unexpected) {
            Log.logSevere(unexpected);
        }
    }

    @Override
    public void postObjectRemoved(E object, ProjectObject parent) {
        try {
            this.delegate.postObjectRemoved(object, parent);
        }
        catch (Throwable unexpected) {
            Log.logSevere(unexpected);
        }
    }

    @Override
    public void objectChanged(E projectObject, ProjectEvent event) {
        try {
            this.delegate.objectChanged(projectObject, event);
        }
        catch (Throwable unexpected) {
            Log.logSevere(unexpected);
        }
    }

    @Override
    public void objectReplaced(E oldObject, E newObject) {
        try {
            this.delegate.objectReplaced(oldObject, newObject);
        }
        catch (Throwable unexpected) {
            Log.logSevere(unexpected);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SafeProjectListener) {
            SafeProjectListener listener = (SafeProjectListener)other;
            return this.delegate.equals(listener.delegate);
        }
        return this.delegate.equals(other);
    }

    public int hashCode() {
        return this.delegate != null ? this.delegate.hashCode() : 0;
    }

    public String toString() {
        return "SafeProjectListener(" + this.delegate + ")";
    }
}

