/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.documentables;

import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.documentables.ProjectObjectDocumentable;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.util.documentation.Documentable;
import oracle.bpm.util.documentation.DocumentationType;
import org.jetbrains.annotations.NotNull;

class LocalizableDocumentable
extends ProjectObjectDocumentable {
    private final Localizable localizable;

    protected LocalizableDocumentable(@NotNull Localizable localizable, @NotNull ProjectObject projectObject) {
        super(projectObject);
        this.localizable = localizable;
    }

    public static <T extends Localizable & ProjectObject> Documentable create(T t) {
        return new LocalizableDocumentable(t, t);
    }

    @Override
    public String getLabel() {
        return this.localizable.getDefaultLabel();
    }

    public void setDocumentation(DocumentationType type, Locale language, String htmlDocumentation) {
        LocaleStringMap documentationMap = null;
        if (type == DocumentationType.DOCUMENTATION) {
            documentationMap = this.localizable.getDocumentationMap();
        } else if (type == DocumentationType.USE_CASE_DOCUMENTATION) {
            documentationMap = this.localizable.getUseCaseDocumentationMap();
        }
        if (documentationMap != null) {
            if (htmlDocumentation != null && htmlDocumentation.trim().length() > 0) {
                documentationMap.put(language, htmlDocumentation.trim());
            } else {
                documentationMap.remove(language);
            }
        }
    }

    public String getDocumentation(DocumentationType type, Locale language) {
        String result = "";
        if (type == DocumentationType.DOCUMENTATION) {
            result = this.localizable.getDocumentationMap().getString(language);
        } else if (type == DocumentationType.USE_CASE_DOCUMENTATION) {
            result = this.localizable.getUseCaseDocumentationMap().getString(language);
        }
        return result;
    }
}

