/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.deployment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.project.ProcessIdsConverterUtils;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.deployment.ProcessDeploymentImpl;
import oracle.bpm.project.deployment.ProcessDeploymentUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.deployment.ProcessDeployment;
import oracle.bpm.project.model.deployment.Topology;
import oracle.bpm.project.model.deployment.ViewsGenerationType;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class TopologyImpl
extends ResourceObjectImpl
implements Topology,
ResourceObject {
    private String activityPresentationId;
    private Map<String, ProcessDeployment> deployments = new HashMap<String, ProcessDeployment>();
    private String inboxPresentationId;
    private String processPresentationId;
    private ViewsGenerationType viewsGenerationType = ViewsGenerationType.UNIFIED_INBOX;

    public TopologyImpl(Project project) {
        super(project);
    }

    @Override
    public Collection<ProcessDeployment> getDeployments() {
        return this.deployments.values();
    }

    @Override
    public void addDeployment(ProcessDeployment deployment) {
        String deployedProcessId = ProcessDeploymentUtils.getDeployedProcessId(deployment);
        this.deployments.put(deployedProcessId, deployment);
        this.events().objectChanged();
    }

    @Override
    public void addDeployment(Process model) {
        ProcessDeployment deployment = this.createDeployment(model.getId(), this.getProject().getOrganization().getRootOrganizationalUnit().getId());
        this.addDeployment(deployment);
    }

    @Override
    public ProcessDeployment removeDeployment(ProcessDeployment deployment) {
        String deployedProcessId = ProcessDeploymentUtils.getDeployedProcessId(deployment);
        return this.deployments.remove(deployedProcessId);
    }

    @Override
    public ProcessDeployment findDeployment(String deployedProcessId) {
        return this.deployments.get(deployedProcessId);
    }

    @Override
    public ProcessDeployment createDeployment(String processName, String ou) {
        return new ProcessDeploymentImpl(this, processName, ou);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.TOPOLOGY;
    }

    @Override
    public void clearDeployments() {
        this.deployments.clear();
    }

    @Override
    public void removeDeployment(Process process) {
        StringList removeList = StringList.create();
        for (ProcessDeployment deployment : this.deployments.values()) {
            String modelDeploymentId = ProcessIdsConverterUtils.deploymentToProjectProcessId(deployment);
            if (!modelDeploymentId.equals(process.getId())) continue;
            removeList.add(ProcessDeploymentUtils.getDeployedProcessId(deployment));
        }
        for (String key : removeList) {
            this.deployments.remove(key);
        }
    }

    @Override
    public ViewsGenerationType getViewsGenerationType() {
        return this.viewsGenerationType;
    }

    @Override
    public void setViewsGenerationType(ViewsGenerationType viewsGenerationType) {
        this.viewsGenerationType = viewsGenerationType;
        this.events().objectChanged();
    }

    @Override
    public void setProcessViewsPresentationId(String processPresentationId) {
        this.processPresentationId = processPresentationId;
        this.events().objectChanged();
    }

    @Override
    public void setInboxViewPresentationId(String inboxPresentationId) {
        this.inboxPresentationId = inboxPresentationId;
        this.events().objectChanged();
    }

    @Override
    public void setActivityViewsPresentationId(String activityPresentationId) {
        this.activityPresentationId = activityPresentationId;
        this.events().objectChanged();
    }

    @Override
    public String getProcessViewsPresentationId() {
        return this.processPresentationId;
    }

    @Override
    public String getActivityViewsPresentationId() {
        return this.activityPresentationId;
    }

    @Override
    public String getInboxViewPresentationId() {
        return this.inboxPresentationId;
    }
}

