/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.deployment;

import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.deployment.ProcessDeploymentUtils;
import oracle.bpm.project.deployment.TopologyImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.deployment.ProcessDeployment;
import oracle.bpm.project.model.deployment.Topology;
import org.jetbrains.annotations.NotNull;

public class ProcessDeploymentImpl
extends ProjectObjectImpl
implements ProcessDeployment,
Comparable {
    private String id;
    private String ou;
    private String processName;
    private Topology topology;

    ProcessDeploymentImpl(TopologyImpl topology, String processName, String ou) {
        super(topology.getProject());
        this.ou = ou;
        this.processName = processName;
        this.topology = topology;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.topology;
    }

    @Override
    public String getProcessName() {
        return this.processName;
    }

    @Override
    public String getOU() {
        return this.ou;
    }

    public void setOU(String ou) {
        this.ou = ou;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PROCESS_DEPLOYMENT;
    }

    public int compareTo(Object o) {
        return ProcessDeploymentUtils.getDeployedProcessId(this).compareTo(ProcessDeploymentUtils.getDeployedProcessId((ProcessDeploymentImpl)o));
    }
}

