/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard.generation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.dashboard.BAMFieldNameProvider;
import oracle.bpm.dashboard.BAMTableNameProvider;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.DimensionType;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.OperationType;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetType;

public class DashboardSQL {
    private List<Argument> sqlArgs = new ArrayList<Argument>();
    private String sqlBamTableName;
    private Collection<String> sqlGroupByNames;
    private Collection<String> sqlSelectNames;
    private Collection<String> sqlTableNames;
    private Collection<String> sqlWhereClauses;

    public DashboardSQL(WidgetDataModel widgetDataModel) {
        this.init(widgetDataModel);
    }

    private DashboardSQL() {
    }

    public final void setBamTableName(String tableName) {
        this.sqlBamTableName = tableName;
        this.addFromTableName(tableName);
    }

    public final String getBamTableName() {
        return this.sqlBamTableName;
    }

    public Argument[] getSqlArgs() {
        return this.sqlArgs.toArray(new Argument[0]);
    }

    public String getSqlQuery() {
        StringBuffer sqlQueryBuffer = new StringBuffer();
        sqlQueryBuffer.append("select ");
        if (this.sqlSelectNames != null) {
            Iterator<String> selectNames = this.sqlSelectNames.iterator();
            while (selectNames.hasNext()) {
                String selectName = selectNames.next();
                sqlQueryBuffer.append(selectName);
                if (!selectNames.hasNext()) continue;
                sqlQueryBuffer.append(", ");
            }
        } else {
            sqlQueryBuffer.append("*");
        }
        assert (this.sqlTableNames != null) : "There must be at least one table";
        sqlQueryBuffer.append("\n from ");
        Iterator<String> tabletNames = this.sqlTableNames.iterator();
        while (tabletNames.hasNext()) {
            String tabletName = tabletNames.next();
            sqlQueryBuffer.append(tabletName);
            if (!tabletNames.hasNext()) continue;
            sqlQueryBuffer.append(", ");
        }
        if (this.sqlWhereClauses != null) {
            sqlQueryBuffer.append("\n where ");
            Iterator<String> whereClauses = this.sqlWhereClauses.iterator();
            while (whereClauses.hasNext()) {
                String whereClause = whereClauses.next();
                sqlQueryBuffer.append(whereClause);
                if (!whereClauses.hasNext()) continue;
                sqlQueryBuffer.append("\n and ");
            }
        }
        if (this.sqlGroupByNames != null) {
            sqlQueryBuffer.append("\n group by ");
            Iterator<String> groupByNames = this.sqlGroupByNames.iterator();
            while (groupByNames.hasNext()) {
                String groupByName = groupByNames.next();
                sqlQueryBuffer.append(groupByName);
                if (!groupByNames.hasNext()) continue;
                sqlQueryBuffer.append(", ");
            }
        }
        return sqlQueryBuffer.toString();
    }

    public void addArgument(String arg) {
        this.sqlArgs.add(new Argument(arg, false));
    }

    public void addParametricArgument(String arg) {
        this.sqlArgs.add(new Argument(arg, true));
    }

    public void addArgument(String arg, String suffix) {
        this.sqlArgs.add(new Argument(arg, false, suffix));
    }

    public void addParametricArgument(String arg, String suffix) {
        this.sqlArgs.add(new Argument(arg, true, suffix));
    }

    public void addFromTableName(String tableName) {
        if (this.sqlTableNames == null) {
            this.sqlTableNames = new TreeSet<String>();
        }
        this.sqlTableNames.add(tableName);
    }

    public void addGroupByName(String groupByName) {
        if (this.sqlGroupByNames == null) {
            this.sqlGroupByNames = new TreeSet<String>();
        }
        this.sqlGroupByNames.add(groupByName);
    }

    public void addSelectName(String selectName) {
        this.addSelectName(selectName, null, null);
    }

    public void addSelectName(String selectName, String operation, String aliasName) {
        if (this.sqlSelectNames == null) {
            this.sqlSelectNames = new TreeSet<String>();
        }
        StringBuffer selectNameBuffer = new StringBuffer();
        if (operation != null) {
            selectNameBuffer.append(operation);
            selectNameBuffer.append("(");
        }
        selectNameBuffer.append(selectName);
        if (operation != null) {
            selectNameBuffer.append(")");
        }
        if (aliasName != null) {
            selectNameBuffer.append(" as ");
            selectNameBuffer.append(aliasName);
        }
        this.sqlSelectNames.add(selectNameBuffer.toString());
    }

    public void addWhereClause(WhereClause whereClause) {
        if (this.sqlWhereClauses == null) {
            this.sqlWhereClauses = new LinkedHashSet<String>();
        }
        this.sqlWhereClauses.add(whereClause.getSQL());
    }

    private void init(WidgetDataModel widgetDataModel) {
        List dimensions = widgetDataModel.getDimensions();
        Dimension dimension1 = null;
        Dimension dimension2 = null;
        if (dimensions != null) {
            for (Dimension dimension : dimensions) {
                if (dimension.getDimensionType() != DimensionType.DIMENSION) continue;
                if (dimension1 == null) {
                    dimension1 = dimension;
                    continue;
                }
                dimension2 = dimension;
            }
        }
        this.initWhereClauses(widgetDataModel);
        this.initSelectAndGroupBy(dimension1, dimension2, widgetDataModel.getMeasurement());
    }

    private void initSelectAndGroupBy(Dimension dimension) {
        if (dimension != null) {
            String columnName;
            if (dimension.hasDescription()) {
                columnName = dimension.getDescriptionColumnName();
                if (!dimension.isDescriptionAvailableWithoutJoin()) {
                    this.addFromTableName(dimension.getDescriptionTableName());
                    WhereClause descriptionClause = WhereClause.getInstance(dimension.getDescriptionTableName(), dimension.getColumnName(), 0, this.getBamTableName(), dimension.getColumnName());
                    this.addWhereClause(descriptionClause);
                }
            } else {
                columnName = dimension.getColumnName();
            }
            this.addSelectName(columnName);
            this.addGroupByName(columnName);
        }
    }

    private void initSelectAndGroupBy(Dimension dimension1, Dimension dimension2, Measurement measurement) {
        assert (measurement != null) : "The measurement must not be null. It is required by the query.";
        this.initSelectAndGroupBy(dimension1);
        this.initSelectAndGroupBy(dimension2);
        String sqlOperationType = OperationType.SUM.name();
        OperationType operationType = measurement.getOperationType();
        if (operationType != null) {
            sqlOperationType = operationType.name();
        }
        this.addSelectName(measurement.getColumnName(), sqlOperationType, measurement.getColumnName());
    }

    private void initWhereClauses(WidgetDataModel widgetDataModel) {
        assert (widgetDataModel != null) : "The widget data model must not be null!";
        WidgetType type = widgetDataModel.getType();
        if (type == WidgetType.ACTIVITY_WORKLOAD || type == WidgetType.ALL_ACTIVITIES_WORKLOAD) {
            this.buildWorkloadWhereClause(type, widgetDataModel);
        } else if (type == WidgetType.ACTIVITY_PERFORMANCE || type == WidgetType.ALL_ACTIVITIES_PERFORMANCE) {
            this.buildActivityPerformanceWhereClause(type, widgetDataModel);
        } else if (type == WidgetType.PROCESS_PERFORMANCE) {
            this.buildProcessPerformanceWhereClause(widgetDataModel);
        } else if (type == WidgetType.ALL_OUS_WORKLOAD || type == WidgetType.OU_WORKLOAD) {
            this.buildOuWorkloadWhereClause(type, widgetDataModel);
        } else if (type == WidgetType.ALL_OUS_ACTIVITY_PERFORMANCE || type == WidgetType.OU_ACTIVITY_PERFORMANCE) {
            this.buildOuActivityPerformanceWhereClause(type, widgetDataModel);
        } else if (type == WidgetType.ALL_OUS_PROCESS_PERFORMANCE || type == WidgetType.OU_PROCESS_PERFORMANCE) {
            this.buildOuProcessPerformanceWhereClause(type, widgetDataModel);
        }
    }

    private void buildOuActivityPerformanceWhereClause(WidgetType type, WidgetDataModel widgetDataModel) {
        this.setBamTableName(BAMTableNameProvider.TaskPerformance());
        this.addFromTableName(BAMTableNameProvider.OUs());
        if (type == WidgetType.OU_ACTIVITY_PERFORMANCE) {
            String columnName = widgetDataModel.isParametricOu() ? BAMFieldNameProvider.OUs_fullPathName() : BAMFieldNameProvider.OUs_name();
            WhereClause ouNameClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), columnName, 0, "?");
            this.addWhereClause(ouNameClause);
            if (widgetDataModel.isParametricOu()) {
                this.addParametricArgument("ou");
            } else {
                this.addArgument(widgetDataModel.getOuName());
            }
        }
        WhereClause ouInClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), BAMFieldNameProvider.OUs_ouIn(), 0, BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_ouIn());
        this.addWhereClause(ouInClause);
        this.addFromTableName(BAMTableNameProvider.Processes());
        WhereClause processInClause = WhereClause.getInstance(BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processIn(), 0, BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_processIn());
        this.addWhereClause(processInClause);
        this.addFromTableName(BAMTableNameProvider.Activities());
        WhereClause activityInClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityIn(), 0, BAMTableNameProvider.TaskPerformance(), BAMFieldNameProvider.TaskPerformance_activityIn());
        this.addWhereClause(activityInClause);
        if (type == WidgetType.ALL_OUS_ACTIVITY_PERFORMANCE) {
            this.addFromTableName(BAMTableNameProvider.Activities());
            WhereClause notActivityMarkClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityId(), 4, "?");
            this.addWhereClause(notActivityMarkClause);
            this.addArgument("%[MARK]");
        }
    }

    private void buildOuProcessPerformanceWhereClause(WidgetType type, WidgetDataModel widgetDataModel) {
        this.setBamTableName(BAMTableNameProvider.ProcessPerformance());
        this.addFromTableName(BAMTableNameProvider.OUs());
        if (type == WidgetType.OU_PROCESS_PERFORMANCE) {
            String columnName = widgetDataModel.isParametricOu() ? BAMFieldNameProvider.OUs_fullPathName() : BAMFieldNameProvider.OUs_name();
            WhereClause ouNameClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), columnName, 0, "?");
            this.addWhereClause(ouNameClause);
            if (widgetDataModel.isParametricOu()) {
                this.addParametricArgument("ou");
            } else {
                this.addArgument(widgetDataModel.getOuName());
            }
        }
        WhereClause ouInClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), BAMFieldNameProvider.OUs_ouIn(), 0, BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_ouIn());
        this.addWhereClause(ouInClause);
        this.addFromTableName(BAMTableNameProvider.Processes());
        WhereClause processInClause = WhereClause.getInstance(BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processIn(), 0, BAMTableNameProvider.ProcessPerformance(), BAMFieldNameProvider.ProcessPerformance_processIn());
        this.addWhereClause(processInClause);
    }

    private void buildOuWorkloadWhereClause(WidgetType type, WidgetDataModel widgetDataModel) {
        this.setBamTableName(BAMTableNameProvider.Workload());
        DashboardSQL sqlAllSnapshot = new DashboardSQL();
        sqlAllSnapshot.addFromTableName(BAMTableNameProvider.LastSnapshot());
        sqlAllSnapshot.addSelectName(BAMFieldNameProvider.LastSnapshot_lastSnapshotTime());
        WhereClause lastSnapshotClause = WhereClause.getInstance(BAMTableNameProvider.Workload(), BAMFieldNameProvider.Workload_snapshotTime(), 2, sqlAllSnapshot.getSqlQuery());
        this.addWhereClause(lastSnapshotClause);
        this.addFromTableName(BAMTableNameProvider.OUs());
        if (type == WidgetType.OU_WORKLOAD) {
            String columnName = widgetDataModel.isParametricOu() ? BAMFieldNameProvider.OUs_fullPathName() : BAMFieldNameProvider.OUs_name();
            WhereClause ouNameClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), columnName, 0, "?");
            this.addWhereClause(ouNameClause);
            if (widgetDataModel.isParametricOu()) {
                this.addParametricArgument("ou");
            } else {
                this.addArgument(widgetDataModel.getOuName());
            }
        }
        WhereClause ouInClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), BAMFieldNameProvider.OUs_ouIn(), 0, BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_ouIn());
        this.addWhereClause(ouInClause);
        this.addFromTableName(BAMTableNameProvider.Processes());
        WhereClause processInClause = WhereClause.getInstance(BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processIn(), 0, BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_processIn());
        this.addWhereClause(processInClause);
        this.addFromTableName(BAMTableNameProvider.Activities());
        WhereClause activityInClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityIn(), 0, BAMTableNameProvider.Workload(), BAMFieldNameProvider.Workload_activityIn());
        this.addWhereClause(activityInClause);
        if (type == WidgetType.ALL_OUS_WORKLOAD) {
            this.addFromTableName(BAMTableNameProvider.Activities());
            WhereClause notActivityMarkClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityId(), 4, "?");
            this.addWhereClause(notActivityMarkClause);
            this.addArgument("%[MARK]");
        }
    }

    private void buildProcessPerformanceWhereClause(WidgetDataModel widgetDataModel) {
        this.setBamTableName(BAMTableNameProvider.ProcessPerformance());
        this.addFromTableName(BAMTableNameProvider.Processes());
        WhereClause processIdClause = WhereClause.getInstance(BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processId(), 3, "?");
        this.addWhereClause(processIdClause);
        this.addFromTableName(BAMTableNameProvider.Processes());
        WhereClause processInClause = WhereClause.getInstance(BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processIn(), 0, BAMTableNameProvider.ProcessPerformance(), BAMFieldNameProvider.ProcessPerformance_processIn());
        this.addWhereClause(processInClause);
        this.addArgument(widgetDataModel.getProcessId() + "%");
    }

    private void buildActivityPerformanceWhereClause(WidgetType type, WidgetDataModel widgetDataModel) {
        this.setBamTableName(BAMTableNameProvider.TaskPerformance());
        if (type == WidgetType.ACTIVITY_PERFORMANCE) {
            this.addFromTableName(BAMTableNameProvider.Activities());
            this.addFromTableName(BAMTableNameProvider.Processes());
            if (widgetDataModel.isParametricOu()) {
                this.addFromTableName(BAMTableNameProvider.OUs());
            }
            WhereClause activityIdClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityId(), 0, "?");
            this.addWhereClause(activityIdClause);
            this.addFromTableName(BAMTableNameProvider.Processes());
            WhereClause processIdClause = WhereClause.getInstance(BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processId(), 3, "?");
            this.addWhereClause(processIdClause);
            this.addFromTableName(BAMTableNameProvider.Activities());
            WhereClause processInClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_processIn(), 0, BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processIn());
            this.addWhereClause(processInClause);
            if (widgetDataModel.isParametricOu()) {
                WhereClause ouInClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), BAMFieldNameProvider.OUs_ouIn(), 0, BAMTableNameProvider.Processes(), BAMFieldNameProvider.OUs_ouIn());
                this.addWhereClause(ouInClause);
                WhereClause ouNameClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), BAMFieldNameProvider.OUs_fullPathName(), 0, "?");
                this.addWhereClause(ouNameClause);
            }
            if (widgetDataModel.isParametricActivity()) {
                this.addParametricArgument("activity");
            } else {
                this.addArgument(widgetDataModel.getActivityId());
            }
            this.addArgument(widgetDataModel.getProcessId(), "%");
            if (widgetDataModel.isParametricOu()) {
                this.addParametricArgument("ou");
            }
        } else {
            this.addFromTableName(BAMTableNameProvider.Processes());
            WhereClause processIdClause = WhereClause.getInstance(BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processId(), 3, "?");
            this.addWhereClause(processIdClause);
            this.addFromTableName(BAMTableNameProvider.Activities());
            WhereClause processInClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_processIn(), 0, BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processIn());
            this.addWhereClause(processInClause);
            this.addFromTableName(BAMTableNameProvider.Activities());
            WhereClause notActivityMarkClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityId(), 4, "?");
            this.addWhereClause(notActivityMarkClause);
            if (widgetDataModel.isParametricProcess()) {
                this.addParametricArgument("process", "%");
            } else {
                this.addArgument(widgetDataModel.getProcessId(), "%");
            }
            this.addArgument("%[MARK]");
        }
        WhereClause activityInClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityIn(), 0, BAMTableNameProvider.TaskPerformance(), BAMFieldNameProvider.TaskPerformance_activityIn());
        this.addWhereClause(activityInClause);
    }

    private void buildWorkloadWhereClause(WidgetType type, WidgetDataModel widgetDataModel) {
        this.setBamTableName(BAMTableNameProvider.Workload());
        DashboardSQL sqlAllSnapshot = new DashboardSQL();
        sqlAllSnapshot.addFromTableName(BAMTableNameProvider.LastSnapshot());
        sqlAllSnapshot.addSelectName(BAMFieldNameProvider.LastSnapshot_lastSnapshotTime());
        WhereClause lastSnapshotClause = WhereClause.getInstance(BAMTableNameProvider.Workload(), BAMFieldNameProvider.Workload_snapshotTime(), 2, sqlAllSnapshot.getSqlQuery());
        this.addWhereClause(lastSnapshotClause);
        if (type == WidgetType.ACTIVITY_WORKLOAD) {
            this.addFromTableName(BAMTableNameProvider.Activities());
            WhereClause activityIdClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityId(), 0, "?");
            this.addWhereClause(activityIdClause);
            if (widgetDataModel.isParametricActivity()) {
                this.addParametricArgument("activity");
            } else {
                this.addArgument(widgetDataModel.getActivityId());
            }
        } else {
            this.addFromTableName(BAMTableNameProvider.Processes());
            if (widgetDataModel.isParametricOu()) {
                this.addFromTableName(BAMTableNameProvider.OUs());
            }
            WhereClause processIdClause = WhereClause.getInstance(BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processId(), 3, "?");
            this.addWhereClause(processIdClause);
            this.addFromTableName(BAMTableNameProvider.Activities());
            WhereClause processInClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_processIn(), 0, BAMTableNameProvider.Processes(), BAMFieldNameProvider.Processes_processIn());
            this.addWhereClause(processInClause);
            this.addFromTableName(BAMTableNameProvider.Activities());
            WhereClause notActivityMarkClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityId(), 4, "?");
            this.addWhereClause(notActivityMarkClause);
            if (widgetDataModel.isParametricOu()) {
                WhereClause ouInClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), BAMFieldNameProvider.OUs_ouIn(), 0, BAMTableNameProvider.Processes(), BAMFieldNameProvider.OUs_ouIn());
                this.addWhereClause(ouInClause);
                WhereClause ouNameClause = WhereClause.getInstance(BAMTableNameProvider.OUs(), BAMFieldNameProvider.OUs_fullPathName(), 0, "?");
                this.addWhereClause(ouNameClause);
            }
            if (widgetDataModel.isParametricProcess()) {
                this.addParametricArgument("process", "%");
            } else {
                this.addArgument(widgetDataModel.getProcessId(), "%");
            }
            this.addArgument("%[MARK]");
            if (widgetDataModel.isParametricOu()) {
                this.addParametricArgument("ou");
            }
        }
        WhereClause activityInClause = WhereClause.getInstance(BAMTableNameProvider.Activities(), BAMFieldNameProvider.Activities_activityIn(), 0, BAMTableNameProvider.Workload(), BAMFieldNameProvider.Workload_activityIn());
        this.addWhereClause(activityInClause);
    }

    private static final class WhereClause {
        private String argument1;
        private String argument2;
        private int comparator;
        public static final int EQUALS = 0;
        public static final int NOT_EQUALS = 1;
        public static final int IN = 2;
        public static final int LIKE = 3;
        public static final int NOT_LIKE = 4;

        private WhereClause(String arg1, int comparator, String arg2) {
            assert (arg1 != null && arg2 != null && comparator >= 0) : "Invalid arguments!";
            this.argument1 = arg1;
            this.argument2 = arg2;
            this.comparator = comparator;
        }

        public static WhereClause getInstance(String arg1, int comparator, String arg2) {
            return new WhereClause(arg1, comparator, arg2);
        }

        public static WhereClause getInstance(String tableName, String columnName, int comparator, String arg2) {
            assert (tableName != null && columnName != null && arg2 != null && comparator >= 0) : "Invalid arguments!";
            StringBuffer arg1 = new StringBuffer();
            arg1.append(tableName);
            arg1.append(".");
            arg1.append(columnName);
            return new WhereClause(arg1.toString(), comparator, arg2);
        }

        public static WhereClause getInstance(String tableName1, String columnName1, int comparator, String tableName2, String columnName2) {
            assert (tableName1 != null && columnName1 != null && tableName2 != null && columnName2 != null && comparator >= 0) : "Invalid arguments!";
            StringBuffer arg2 = new StringBuffer();
            arg2.append(tableName2);
            arg2.append(".");
            arg2.append(columnName2);
            return WhereClause.getInstance(tableName1, columnName1, comparator, arg2.toString());
        }

        private String getSQL() {
            StringBuffer sql = new StringBuffer();
            sql.append(this.argument1);
            switch (this.comparator) {
                default: {
                    sql.append(" = ");
                    break;
                }
                case 1: {
                    sql.append(" != ");
                    break;
                }
                case 2: {
                    sql.append(" in (");
                    break;
                }
                case 3: {
                    sql.append(" like ");
                    break;
                }
                case 4: {
                    sql.append(" not like ");
                }
            }
            sql.append(this.argument2);
            switch (this.comparator) {
                case 2: {
                    sql.append(")");
                    break;
                }
            }
            return sql.toString();
        }
    }

    public static class Argument {
        private String name;
        private boolean parametric;
        private String suffix;

        public Argument(String name, boolean parametric) {
            this(name, parametric, null);
        }

        public Argument(String name, boolean parametric, String suffix) {
            this.parametric = parametric;
            this.name = name;
            this.suffix = suffix;
        }

        public boolean isParametric() {
            return this.parametric;
        }

        public String getName() {
            return this.name;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean hasSuffix() {
            return this.suffix != null;
        }
    }
}

