/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard.generation;

import java.io.StringWriter;
import java.util.List;
import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.drilldown.ViewDrillDown;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.dashboard.drilldown.WidgetDrillDownAdapter;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;

public class DashboardMethodFactory {
    private static final String DRILL_DOWN_METHOD_PREFIX = "drillDownTo";
    public static final String DRILL_DOWN_SUFFIX = "Dashboard";
    public static final String DRILL_DOWN_PREFIX = "DrillDown";
    private static final String VIEW_DRILL_DOWN_METHOD_PREFIX = "View";

    public static String buildWidgetDrillDownMethodName(WidgetModel drillDownWidget) {
        return DRILL_DOWN_METHOD_PREFIX + drillDownWidget.getName();
    }

    public static MethodTypeDescription createWidgetDrillDownMethod(WidgetDrillDownAdapter drillDownWidget, WidgetModel drilledDownWidget) {
        String language;
        StringWriter codeWriter = new StringWriter();
        IndentedPrintWriter codePrinter = new IndentedPrintWriter(codeWriter);
        WidgetModel widgetToDrillTo = drillDownWidget.getWidget();
        String methodName = DashboardMethodFactory.buildWidgetDrillDownMethodName(widgetToDrillTo);
        try {
            language = LanguageSpec.getLanguageSpec((String)"Fuego").getId();
        }
        catch (InvalidLanguageException e) {
            language = "Fuego";
        }
        codePrinter.println("//Drill down to another widget");
        String drillDownDashboardName = drillDownWidget.getName() + DRILL_DOWN_PREFIX + DRILL_DOWN_SUFFIX;
        codePrinter.println("drillDown as " + drillDownDashboardName);
        codePrinter.println("drillDown = " + drillDownDashboardName + "()");
        WidgetDataModel widgetToDrillToDataModel = widgetToDrillTo.getDataModel();
        if (widgetToDrillToDataModel.isParametricOu()) {
            codePrinter.println("drillDown.ou=ou");
        }
        if (widgetToDrillToDataModel.isParametricProcess()) {
            codePrinter.println("drillDown.process=process");
        }
        if (widgetToDrillToDataModel.isParametricActivity()) {
            codePrinter.println("drillDown.activity=activity");
        }
        codePrinter.println();
        codePrinter.println("show this using instance=drillDown,");
        codePrinter.print("presentationName=");
        codePrinter.printQuoted("Presentation");
        codePrinter.flush();
        codePrinter.close();
        MethodTypeDescription drillDownMethod = BpmObjectTypeDescriptionHelper.createMethod((String)methodName, (TypeRef)TypeFactory.getVoid(), null, (String)codeWriter.toString(), (String)language);
        DashboardMethodFactory.addArguments(drilledDownWidget, drillDownMethod);
        return drillDownMethod;
    }

    public static MethodTypeDescription createViewDrillDownMethod(WidgetModel drilledDownWidget, ViewDrillDown drillDownView) {
        String language;
        StringWriter codeWriter = new StringWriter();
        IndentedPrintWriter codePrinter = new IndentedPrintWriter(codeWriter);
        String methodName = DashboardMethodFactory.buildViewDrillDownMethodName(drillDownView);
        try {
            language = LanguageSpec.getLanguageSpec((String)"Fuego").getId();
        }
        catch (InvalidLanguageException e) {
            language = "Fuego";
        }
        String viewId = drillDownView.getViewId();
        codePrinter.println("//Drill down to view");
        codePrinter.print("viewId as String = ");
        codePrinter.printQuoted(viewId);
        codePrinter.println("");
        codePrinter.println("connectTo ClientBusinessProcess");
        codePrinter.print("using processId =");
        codePrinter.printQuoted("/" + drilledDownWidget.getDataModel().getProcessId());
        codePrinter.println("");
        codePrinter.println("");
        codePrinter.println("do");
        WidgetDataModel drilledDownWidgetDataModel = drilledDownWidget.getDataModel();
        List dimensions = drilledDownWidgetDataModel.getDimensions();
        if (dimensions.size() != 0) {
            DashboardMethodFactory.obtainInstanceFilter(codePrinter, viewId);
        }
        for (Dimension dimension : dimensions) {
            if (!dimension.getName().equals(dimension.getKind().getString())) continue;
            DashboardMethodFactory.setParamToViewDrillDown(codePrinter, dimension.getKind().getEquivalentVariableName(), dimension.getKind().getVarName());
        }
        DashboardMethodFactory.addOpenViewCode(codePrinter);
        codePrinter.println("end");
        codePrinter.flush();
        codePrinter.close();
        MethodTypeDescription method = BpmObjectTypeDescriptionHelper.createMethod((String)methodName, (TypeRef)TypeFactory.getVoid(), null, (String)codeWriter.toString(), (String)language);
        DashboardMethodFactory.addArguments(drilledDownWidget, method);
        return method;
    }

    public static String buildViewDrillDownMethodName(ViewDrillDown view) {
        return Identifier.valid("drillDownToView" + DashboardMethodFactory.getViewIdAsMethodName(view));
    }

    public static String getAsMethodName(String name) {
        if (name != null && name.length() > 0 && Character.isUpperCase(name.charAt(0))) {
            char[] charArray = name.toCharArray();
            charArray[0] = Character.toLowerCase(charArray[0]);
            name = String.valueOf(charArray);
        }
        return name;
    }

    public static MethodTypeDescription[] createInstancesViewDrillDownMethods(WidgetModel drilledDownWidget) {
        String language;
        StringWriter codeWriter = new StringWriter();
        IndentedPrintWriter codePrinter = new IndentedPrintWriter(codeWriter);
        String methodName = DashboardMethodFactory.buildInstancesViewDrillDownMethodName();
        try {
            language = LanguageSpec.getLanguageSpec((String)"Fuego").getId();
        }
        catch (InvalidLanguageException e) {
            language = "Fuego";
        }
        codePrinter.println("//Drill down to view");
        codePrinter.println("connectTo ClientBusinessProcess");
        codePrinter.print("using processId = ou + ");
        codePrinter.printQuoted("/");
        codePrinter.print(" + process");
        codePrinter.println("");
        codePrinter.println("");
        codePrinter.println("do");
        codePrinter.println("// Paramatric filter //");
        codePrinter.println("instanceFilter as InstanceFilter = InstanceFilter()");
        codePrinter.print("viewId as String = ");
        codePrinter.printQuoted("InstancesView");
        codePrinter.println("");
        codePrinter.println("create instanceFilter");
        codePrinter.println("using processService = ClientBusinessProcess.processService, viewId = viewId");
        codePrinter.println("");
        codePrinter.println("for each tmpProcess in ClientBusinessProcess.processService.processes do");
        codePrinter.println("if tmpProcess.organizationUnit = ou and tmpProcess.name = process then");
        codePrinter.println("addAttributeTo instanceFilter");
        codePrinter.println("using variable = VarDefinition.PROCESS_ID,");
        codePrinter.println("comparator = Comparison.IS,");
        codePrinter.println("value = tmpProcess.id");
        codePrinter.println("end");
        codePrinter.println("end");
        codePrinter.println("addAttributeTo instanceFilter");
        codePrinter.println("using variable = VarDefinition.ACTIVITY_ID,");
        codePrinter.println("comparator = Comparison.IS,");
        codePrinter.println("value = activity");
        DashboardMethodFactory.addOpenViewCode(codePrinter);
        codePrinter.println("end");
        codePrinter.flush();
        codePrinter.close();
        MethodTypeDescription method = BpmObjectTypeDescriptionHelper.createMethod((String)methodName, (TypeRef)TypeFactory.getVoid(), null, (String)codeWriter.toString(), (String)language);
        DashboardMethodFactory.addArguments(drilledDownWidget, method);
        return new MethodTypeDescription[]{method};
    }

    public static String buildInstancesViewDrillDownMethodName() {
        return "drillDownToInstancesView";
    }

    private static void addArguments(WidgetModel widgetModel, MethodTypeDescription drillDownMethod) {
        List dimensions = widgetModel.getDataModel().getDimensions();
        for (Dimension dimension : dimensions) {
            String dimensionName = dimension.getVarName();
            drillDownMethod.addArgument(new Argument(dimensionName, (TypeRef)TypeFactory.getString(), 1L));
        }
        if (widgetModel.getPresentationModel().getSubType().getGraphicType().equals("XYZ") && dimensions.size() == 1) {
            drillDownMethod.addArgument(new Argument("unUsed", (TypeRef)TypeFactory.getString(), 1L));
        }
    }

    private static void addOpenViewCode(IndentedPrintWriter codePrinter) {
        codePrinter.println("broadcastViewChangeEvent this");
        codePrinter.println("using viewId = viewId");
    }

    private static String getViewIdAsMethodName(ViewDrillDown viewModel) {
        assert (viewModel != null) : "The widgetModel can not be null!";
        String viewId = viewModel.getViewId();
        viewId = DashboardMethodFactory.getAsMethodName(viewId);
        return viewId;
    }

    private static void obtainInstanceFilter(IndentedPrintWriter codePrinter, String viewId) {
        codePrinter.println("//Paramatric filter //");
        codePrinter.print("instanceFilter = getFilterFor(");
        codePrinter.println("ClientBusinessProcess.processService,");
        codePrinter.print("viewId :");
        codePrinter.printQuoted(viewId);
        codePrinter.println(")");
        codePrinter.println();
    }

    private static void setParamToViewDrillDown(IndentedPrintWriter codePrinter, String variable, String value) {
        codePrinter.println("setParametricValueTo instanceFilter");
        codePrinter.print("using variable =");
        codePrinter.print(variable);
        codePrinter.println(",");
        codePrinter.print("value = ");
        codePrinter.println(value);
        codePrinter.println();
    }
}

