/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.dashboard.model.Resource;
import oracle.bpm.dashboard.model.WidgetGraphicType;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.util.Locales;
import oracle.bpm.xobject.GraphicType;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;

public class WidgetPresentationModelImpl
implements WidgetPresentationModel.Mutable {
    private ColorInfo backgroundColor;
    private FullBorderProperties border;
    private BusinessVariableData.Range criticalRange;
    private ColorInfo criticalRangeColor;
    private String dataLabelFormat;
    private ColorInfo foregroundColor;
    private int height;
    private LocaleStringMap localizedTitles;
    private transient Map localizedTitlesTmp;
    private String name;
    private BusinessVariableData.Range normalRange;
    private ColorInfo normalRangeColor;
    private int orientation;
    private ColorInfo outlineColor;
    private ColorInfo plotBackgroundColor;
    private ColorInfo plotOutlineColor;
    private Project project;
    private int refreshRate;
    private List<ColorInfo> seriesColor = new ArrayList<ColorInfo>();
    private ColorInfo seriesDataLabelColor;
    private FontInfo seriesDataLabelFont;
    private ColorInfo shadowColor;
    private GraphicType subType;
    private ColorInfo titleBackgroundColor;
    private FontInfo titleFont;
    private ColorInfo titleForegroundColor;
    private transient String tmpTitle;
    private BusinessVariableData.Range totalRange;
    private WidgetGraphicType type;
    private boolean typeSelectionAllowed;
    private boolean usrSelectionAllowed;
    private ColorInfo valueColor;
    private FontInfo valueFont;
    private BusinessVariableData.Range warningRange;
    private ColorInfo warningRangeColor;
    private int width;

    public WidgetPresentationModelImpl() {
        this.localizedTitles = LocaleStringMap.create();
    }

    public WidgetPresentationModelImpl(Project project) {
        this.project = project;
        this.localizedTitles = LocaleStringMap.create();
    }

    public void loadLocalizedTitles() {
        if (this.localizedTitlesTmp != null) {
            for (Locale locale : this.localizedTitlesTmp.keySet()) {
                Resource title = (Resource)this.localizedTitlesTmp.get(locale);
                String titleValue = title.getValue();
                this.localizedTitles.put(locale, titleValue);
            }
        }
    }

    public void addLocalizedTitle(Resource title) {
        Locale locale = Locales.valueOf(title.getLanguage());
        if (this.localizedTitlesTmp == null) {
            this.localizedTitlesTmp = new HashMap();
        }
        this.localizedTitlesTmp.put(locale, title);
    }

    public void setBackgroundColor(ColorInfo backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public ColorInfo getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBorder(FullBorderProperties border) {
        this.border = border;
    }

    public FullBorderProperties getBorder() {
        return this.border;
    }

    public void setProject(Project project) {
        this.project = project;
        if (this.tmpTitle != null) {
            this.setTitle(this.tmpTitle);
        }
    }

    public void setCriticalRange(BusinessVariableData.Range criticalRange) {
        this.criticalRange = criticalRange;
    }

    public BusinessVariableData.Range getCriticalRange() {
        return this.criticalRange;
    }

    public ColorInfo getValueColor() {
        if (this.valueColor == null) {
            this.valueColor = this.type.equals((Object)WidgetGraphicType.GAUGE) ? (this.subType == GraphicType.GAUGE_SPEEDOMETER ? ColorInfo.WHITE : ColorInfo.BLACK) : ColorInfo.BLACK;
        }
        return this.valueColor;
    }

    public FontInfo getValueFont() {
        if (this.valueFont == null) {
            this.valueFont = FontInfo.valueOf("Verdana", 0, 15);
        }
        return this.valueFont;
    }

    public LocaleStringMap getLocalizedTitles() {
        if (this.localizedTitles == null) {
            this.localizedTitles = LocaleStringMap.create();
        }
        return this.localizedTitles;
    }

    public void setCriticalRangeColor(ColorInfo criticalRangeColor) {
        this.criticalRangeColor = criticalRangeColor;
    }

    public ColorInfo getCriticalRangeColor() {
        return this.criticalRangeColor;
    }

    public void setDataLabelFormat(String dataLabelFormat) {
        this.dataLabelFormat = dataLabelFormat;
    }

    public String getDataLabelFormat() {
        return this.dataLabelFormat;
    }

    public void setForegroundColor(ColorInfo foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public ColorInfo getForegroundColor() {
        return this.foregroundColor;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNormalRange(BusinessVariableData.Range normalRange) {
        this.normalRange = normalRange;
    }

    public BusinessVariableData.Range getNormalRange() {
        return this.normalRange;
    }

    public void setNormalRangeColor(ColorInfo normalRangeColor) {
        this.normalRangeColor = normalRangeColor;
    }

    public ColorInfo getNormalRangeColor() {
        return this.normalRangeColor;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOutlineColor(ColorInfo outlineColor) {
        this.outlineColor = outlineColor;
    }

    public ColorInfo getOutlineColor() {
        return this.outlineColor;
    }

    public void setPlotBackgroundColor(ColorInfo plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    public ColorInfo getPlotBackgroundColor() {
        return this.plotBackgroundColor;
    }

    public void setPlotOutlineColor(ColorInfo plotOutlineColor) {
        this.plotOutlineColor = plotOutlineColor;
    }

    public ColorInfo getPlotOutlineColor() {
        return this.plotOutlineColor;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setSeriesColor(List<ColorInfo> seriesColor) {
        this.seriesColor = seriesColor;
    }

    public List<ColorInfo> getSeriesColor() {
        return this.seriesColor;
    }

    public void setSeriesDataLabelColor(ColorInfo seriesDataLabelColor) {
        this.seriesDataLabelColor = seriesDataLabelColor;
    }

    public ColorInfo getSeriesDataLabelColor() {
        return this.seriesDataLabelColor;
    }

    public void setSeriesDataLabelFont(FontInfo seriesDataLabelFont) {
        this.seriesDataLabelFont = seriesDataLabelFont;
    }

    public FontInfo getSeriesDataLabelFont() {
        return this.seriesDataLabelFont;
    }

    public void setShadowColor(ColorInfo shadowColor) {
        this.shadowColor = shadowColor;
    }

    public ColorInfo getShadowColor() {
        return this.shadowColor;
    }

    public void setSubType(String subType) {
        this.subType = GraphicType.valueOf((String)subType);
    }

    public void setSubType(GraphicType subType) {
        this.subType = subType;
    }

    public GraphicType getSubType() {
        return this.subType;
    }

    public void setTitle(String title) {
        if (this.project != null) {
            this.localizedTitles.put(this.project.getDefaultLanguage(), title);
        } else {
            this.tmpTitle = title;
        }
    }

    public void setValueColor(ColorInfo valueColor) {
        this.valueColor = valueColor;
    }

    public void setValueFont(FontInfo valueFont) {
        this.valueFont = valueFont;
    }

    public void setLocalizedTitles(LocaleStringMap localizedTitles) {
        this.localizedTitles = localizedTitles;
    }

    public String getTitle() {
        return this.localizedTitles.getString(this.project.getDefaultLanguage());
    }

    public void setTitleBackgroundColor(ColorInfo titleBackgroundColor) {
        this.titleBackgroundColor = titleBackgroundColor;
    }

    public ColorInfo getTitleBackgroundColor() {
        return this.titleBackgroundColor;
    }

    public void setTitleFont(FontInfo titleFont) {
        this.titleFont = titleFont;
    }

    public FontInfo getTitleFont() {
        return this.titleFont;
    }

    public void setTitleForegroundColor(ColorInfo titleForegroundColor) {
        this.titleForegroundColor = titleForegroundColor;
    }

    public ColorInfo getTitleForegroundColor() {
        return this.titleForegroundColor;
    }

    public void setTotalRange(BusinessVariableData.Range totalRange) {
        this.totalRange = totalRange;
    }

    public BusinessVariableData.Range getTotalRange() {
        return this.totalRange;
    }

    public void setType(String type) {
        this.type = WidgetGraphicType.valueOf((String)type);
    }

    public void setType(WidgetGraphicType type) {
        this.type = type;
    }

    public WidgetGraphicType getType() {
        return this.type;
    }

    public void setTypeSelectionAllowed(boolean typeSelectionAllowed) {
        this.typeSelectionAllowed = typeSelectionAllowed;
    }

    public boolean isTypeSelectionAllowed() {
        return this.typeSelectionAllowed;
    }

    public void setUsrSelectionAllowed(boolean usrSelectionAllowed) {
        this.usrSelectionAllowed = usrSelectionAllowed;
    }

    public boolean isUsrSelectionAllowed() {
        return this.usrSelectionAllowed;
    }

    public void setWarningRange(BusinessVariableData.Range warningRange) {
        this.warningRange = warningRange;
    }

    public BusinessVariableData.Range getWarningRange() {
        return this.warningRange;
    }

    public void setWarningRangeColor(ColorInfo warningRangeColor) {
        this.warningRangeColor = warningRangeColor;
    }

    public ColorInfo getWarningRangeColor() {
        return this.warningRangeColor;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void addSeriesColor(ColorInfo color) {
        this.seriesColor.add(color);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WidgetPresentationModelImpl)) {
            return false;
        }
        WidgetPresentationModelImpl widgetPresentationModel = (WidgetPresentationModelImpl)o;
        if (this.height != widgetPresentationModel.height) {
            return false;
        }
        if (this.orientation != widgetPresentationModel.orientation) {
            return false;
        }
        if (this.refreshRate != widgetPresentationModel.refreshRate) {
            return false;
        }
        if (this.typeSelectionAllowed != widgetPresentationModel.typeSelectionAllowed) {
            return false;
        }
        if (this.usrSelectionAllowed != widgetPresentationModel.usrSelectionAllowed) {
            return false;
        }
        if (this.width != widgetPresentationModel.width) {
            return false;
        }
        if (this.backgroundColor != null ? !this.backgroundColor.equals(widgetPresentationModel.backgroundColor) : widgetPresentationModel.backgroundColor != null) {
            return false;
        }
        if (this.border != null ? !this.border.equals(widgetPresentationModel.border) : widgetPresentationModel.border != null) {
            return false;
        }
        if (this.criticalRange != null ? !this.criticalRange.equals((Object)widgetPresentationModel.criticalRange) : widgetPresentationModel.criticalRange != null) {
            return false;
        }
        if (this.criticalRangeColor != null ? !this.criticalRangeColor.equals(widgetPresentationModel.criticalRangeColor) : widgetPresentationModel.criticalRangeColor != null) {
            return false;
        }
        if (this.dataLabelFormat != null ? !this.dataLabelFormat.equals(widgetPresentationModel.dataLabelFormat) : widgetPresentationModel.dataLabelFormat != null) {
            return false;
        }
        if (this.foregroundColor != null ? !this.foregroundColor.equals(widgetPresentationModel.foregroundColor) : widgetPresentationModel.foregroundColor != null) {
            return false;
        }
        if (!this.name.equals(widgetPresentationModel.name)) {
            return false;
        }
        if (this.normalRange != null ? !this.normalRange.equals((Object)widgetPresentationModel.normalRange) : widgetPresentationModel.normalRange != null) {
            return false;
        }
        if (this.normalRangeColor != null ? !this.normalRangeColor.equals(widgetPresentationModel.normalRangeColor) : widgetPresentationModel.normalRangeColor != null) {
            return false;
        }
        if (this.outlineColor != null ? !this.outlineColor.equals(widgetPresentationModel.outlineColor) : widgetPresentationModel.outlineColor != null) {
            return false;
        }
        if (this.plotBackgroundColor != null ? !this.plotBackgroundColor.equals(widgetPresentationModel.plotBackgroundColor) : widgetPresentationModel.plotBackgroundColor != null) {
            return false;
        }
        if (this.plotOutlineColor != null ? !this.plotOutlineColor.equals(widgetPresentationModel.plotOutlineColor) : widgetPresentationModel.plotOutlineColor != null) {
            return false;
        }
        if (this.seriesColor != null ? !((Object)this.seriesColor).equals(widgetPresentationModel.seriesColor) : widgetPresentationModel.seriesColor != null) {
            return false;
        }
        if (this.seriesDataLabelColor != null ? !this.seriesDataLabelColor.equals(widgetPresentationModel.seriesDataLabelColor) : widgetPresentationModel.seriesDataLabelColor != null) {
            return false;
        }
        if (this.seriesDataLabelFont != null ? !this.seriesDataLabelFont.equals(widgetPresentationModel.seriesDataLabelFont) : widgetPresentationModel.seriesDataLabelFont != null) {
            return false;
        }
        if (this.shadowColor != null ? !this.shadowColor.equals(widgetPresentationModel.shadowColor) : widgetPresentationModel.shadowColor != null) {
            return false;
        }
        if (!this.subType.equals((Object)widgetPresentationModel.subType)) {
            return false;
        }
        if (this.localizedTitles != null ? !this.localizedTitles.equals(widgetPresentationModel.localizedTitles) : widgetPresentationModel.localizedTitles != null) {
            return false;
        }
        if (this.titleFont != null ? !this.titleFont.equals(widgetPresentationModel.titleFont) : widgetPresentationModel.titleFont != null) {
            return false;
        }
        if (this.totalRange != null ? !this.totalRange.equals((Object)widgetPresentationModel.totalRange) : widgetPresentationModel.totalRange != null) {
            return false;
        }
        if (!this.type.equals((Object)widgetPresentationModel.type)) {
            return false;
        }
        if (this.warningRange != null ? !this.warningRange.equals((Object)widgetPresentationModel.warningRange) : widgetPresentationModel.warningRange != null) {
            return false;
        }
        if (this.warningRangeColor != null ? !this.warningRangeColor.equals(widgetPresentationModel.warningRangeColor) : widgetPresentationModel.warningRangeColor != null) {
            return false;
        }
        if (this.titleBackgroundColor != null ? !this.titleBackgroundColor.equals(widgetPresentationModel.titleBackgroundColor) : widgetPresentationModel.titleBackgroundColor != null) {
            return false;
        }
        return !(this.titleForegroundColor != null ? !this.titleForegroundColor.equals(widgetPresentationModel.titleForegroundColor) : widgetPresentationModel.warningRangeColor != null);
    }

    public int hashCode() {
        int result = this.backgroundColor != null ? this.backgroundColor.hashCode() : 0;
        result = 29 * result + (this.criticalRangeColor != null ? this.criticalRangeColor.hashCode() : 0);
        result = 29 * result + (this.foregroundColor != null ? this.foregroundColor.hashCode() : 0);
        result = 29 * result + (this.normalRangeColor != null ? this.normalRangeColor.hashCode() : 0);
        result = 29 * result + (this.outlineColor != null ? this.outlineColor.hashCode() : 0);
        result = 29 * result + (this.plotBackgroundColor != null ? this.plotBackgroundColor.hashCode() : 0);
        result = 29 * result + (this.plotOutlineColor != null ? this.plotOutlineColor.hashCode() : 0);
        result = 29 * result + (this.seriesDataLabelColor != null ? this.seriesDataLabelColor.hashCode() : 0);
        result = 29 * result + (this.shadowColor != null ? this.shadowColor.hashCode() : 0);
        result = 29 * result + (this.warningRangeColor != null ? this.warningRangeColor.hashCode() : 0);
        result = 29 * result + (this.seriesDataLabelFont != null ? this.seriesDataLabelFont.hashCode() : 0);
        result = 29 * result + (this.titleBackgroundColor != null ? this.titleBackgroundColor.hashCode() : 0);
        result = 29 * result + (this.titleForegroundColor != null ? this.titleForegroundColor.hashCode() : 0);
        result = 29 * result + (this.titleFont != null ? this.titleFont.hashCode() : 0);
        result = 29 * result + (this.border != null ? this.border.hashCode() : 0);
        result = 29 * result + this.subType.hashCode();
        result = 29 * result + (this.seriesColor != null ? ((Object)this.seriesColor).hashCode() : 0);
        result = 29 * result + (this.criticalRange != null ? this.criticalRange.hashCode() : 0);
        result = 29 * result + (this.normalRange != null ? this.normalRange.hashCode() : 0);
        result = 29 * result + (this.totalRange != null ? this.totalRange.hashCode() : 0);
        result = 29 * result + (this.warningRange != null ? this.warningRange.hashCode() : 0);
        result = 29 * result + (this.dataLabelFormat != null ? this.dataLabelFormat.hashCode() : 0);
        result = 29 * result + this.name.hashCode();
        result = 29 * result + (this.localizedTitles != null ? this.localizedTitles.hashCode() : 0);
        result = 29 * result + this.type.hashCode();
        result = 29 * result + (this.typeSelectionAllowed ? 1 : 0);
        result = 29 * result + (this.usrSelectionAllowed ? 1 : 0);
        result = 29 * result + this.height;
        result = 29 * result + this.orientation;
        result = 29 * result + this.refreshRate;
        result = 29 * result + this.width;
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("WidgetPresentationModelImpl");
        buf.append("{backgroundColor=").append(this.backgroundColor);
        buf.append(",criticalRangeColor=").append(this.criticalRangeColor);
        buf.append(",foregroundColor=").append(this.foregroundColor);
        buf.append(",normalRangeColor=").append(this.normalRangeColor);
        buf.append(",outlineColor=").append(this.outlineColor);
        buf.append(",plotBackgroundColor=").append(this.plotBackgroundColor);
        buf.append(",plotOutlineColor=").append(this.plotOutlineColor);
        buf.append(",seriesDataLabelColor=").append(this.seriesDataLabelColor);
        buf.append(",shadowColor=").append(this.shadowColor);
        buf.append(",warningRangeColor=").append(this.warningRangeColor);
        buf.append(",seriesDataLabelFont=").append(this.seriesDataLabelFont);
        buf.append(",titleForegroundColor=").append(this.titleForegroundColor);
        buf.append(",titleBackgroundColor=").append(this.titleBackgroundColor);
        buf.append(",titleFont=").append(this.titleFont);
        buf.append(",border=").append(this.border);
        buf.append(",subType=").append(this.subType);
        buf.append(",seriesColor=").append(this.seriesColor);
        buf.append(",criticalRange=").append(this.criticalRange);
        buf.append(",normalRange=").append(this.normalRange);
        buf.append(",totalRange=").append(this.totalRange);
        buf.append(",warningRange=").append(this.warningRange);
        buf.append(",dataLabelFormat=").append(this.dataLabelFormat);
        buf.append(",name=").append(this.name);
        buf.append(",type=").append(this.type);
        buf.append(",typeSelectionAllowed=").append(this.typeSelectionAllowed);
        buf.append(",usrSelectionAllowed=").append(this.usrSelectionAllowed);
        buf.append(",height=").append(this.height);
        buf.append(",orientation=").append(this.orientation);
        buf.append(",refreshRate=").append(this.refreshRate);
        buf.append(",width=").append(this.width);
        buf.append(",localized titles=").append(this.getLocalizedTitles());
        buf.append('}');
        return buf.toString();
    }

    public WidgetPresentationModel.Mutable asMutable() {
        return this;
    }
}

