/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard;

import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetGraphicType;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.xobject.GraphicType;
import org.jetbrains.annotations.NotNull;

public class WidgetModelImpl
extends ResourceObjectImpl
implements WidgetModel.Mutable,
ResourceObject {
    private WidgetDataModel dataModel;
    private String name;
    private WidgetPresentationModel presentationModel;

    public WidgetModelImpl() {
        super(null);
    }

    public WidgetModelImpl(Project project) {
        super(project);
    }

    public void setDataModel(WidgetDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public WidgetDataModel getDataModel() {
        return this.dataModel;
    }

    public int getDrillDownArgumentQuantity() {
        int result = 0;
        WidgetGraphicType type = this.presentationModel.getType();
        if (type == WidgetGraphicType.CHART) {
            result = 2;
        } else if (type == WidgetGraphicType.PIE) {
            result = 1;
        }
        return result;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setPresentationModel(WidgetPresentationModel presentationModel) {
        this.presentationModel = presentationModel;
    }

    public WidgetPresentationModel getPresentationModel() {
        return this.presentationModel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WidgetModelImpl)) {
            return false;
        }
        WidgetModelImpl widgetModel = (WidgetModelImpl)o;
        if (!this.dataModel.equals(widgetModel.dataModel)) {
            return false;
        }
        if (!this.name.equals(widgetModel.name)) {
            return false;
        }
        return this.presentationModel.equals(widgetModel.presentationModel);
    }

    public void guessTypeBasedOnDimensions() {
        int dimensionQty = this.dataModel.getDimensionQuantity();
        if (dimensionQty == 0) {
            this.presentationModel.asMutable().setType(WidgetGraphicType.GAUGE);
            this.presentationModel.asMutable().setSubType(GraphicType.GAUGE_SPEEDOMETER);
            this.presentationModel.asMutable().setOrientation(1);
        } else if (dimensionQty == 1) {
            this.presentationModel.asMutable().setType(WidgetGraphicType.PIE);
            this.presentationModel.asMutable().setSubType(GraphicType.PIE);
            this.presentationModel.asMutable().setOrientation(1);
        } else if (dimensionQty == 2) {
            this.presentationModel.asMutable().setType(WidgetGraphicType.CHART);
            this.presentationModel.asMutable().setSubType(GraphicType.BAR_CHART);
        }
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 29 * result + this.dataModel.hashCode();
        result = 29 * result + this.presentationModel.hashCode();
        return result;
    }

    @NotNull
    public WidgetModel.Mutable asMutable() {
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("WidgetModelImpl");
        buf.append("{dataModel=").append(this.dataModel);
        buf.append(",name=").append(this.name);
        buf.append(",presentationModel=").append(this.presentationModel);
        buf.append('}');
        return buf.toString();
    }

    @Override
    public void setId(String id) {
        this.setName(id);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.WIDGET;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public Path getPath() {
        return Path.WIDGETS.create(this.id);
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getProject();
    }

    public void setProject(Project project) {
        this.project = project;
        WidgetPresentationModel widgetPresentationModel = this.getPresentationModel();
        if (widgetPresentationModel != null) {
            widgetPresentationModel.setProject(project);
        }
    }
}

