/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.DimensionKind;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.dashboard.model.WidgetValueType;
import oracle.bpm.dashboard.model.drilldown.DrillDown;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.dashboard.DimensionFactoryImpl;
import oracle.bpm.project.dashboard.DimensionImpl;
import oracle.bpm.project.dashboard.MeasurementImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.processes.AnnotationsEnabled;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class WidgetDataModelImpl
extends ProjectObjectImpl
implements WidgetDataModel.Mutable {
    private String activityId;
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private DrillDown drillDown;
    private boolean hasDrillDown;
    private Measurement measurement;
    private String ouName;
    private boolean parametricActivity;
    private boolean parametricOu;
    private boolean parametricProcess;
    private String processId;
    private WidgetType type;
    private WidgetValueType valueType = WidgetValueType.VALUE;

    public WidgetDataModelImpl() {
        this(null);
    }

    public WidgetDataModelImpl(Project project) {
        super(project);
    }

    public WidgetValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = WidgetValueType.valueOf((String)valueType);
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public int getDimensionQuantity() {
        return this.dimensions.size();
    }

    public void setDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public int getDrillDownParametersQuantity() {
        int result = 0;
        if (this.parametricActivity) {
            ++result;
        }
        if (this.parametricOu) {
            ++result;
        }
        if (this.parametricProcess) {
            ++result;
        }
        return result;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setType(String type) {
        this.type = WidgetType.valueOf((String)type);
    }

    public void setType(WidgetType type) {
        this.type = type;
    }

    public WidgetType getType() {
        return this.type;
    }

    public void addDimension(Dimension dimension) {
        this.dimensions.add(dimension);
    }

    public List<Dimension> getAvailableDimensionsForX() {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        Process process = this.project.findProcess(this.processId);
        FlowNode node = process != null ? process.findNode(this.activityId) : null;
        AnnotationsEnabled element = node != null ? node : process;
        List<Dimension> dimensionList = new DimensionFactoryImpl(this.project).getDimensionsFor(this.type, (ProjectObject)((Object)element), process);
        if (this.dimensions != null) {
            for (Dimension dimension : dimensionList) {
                result.add(dimension);
            }
        }
        return result;
    }

    public List<Dimension> getAvailableDimensionsForSerie() {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        Process process = this.project.findProcess(this.processId);
        FlowNode node = process != null ? process.findNode(this.activityId) : null;
        AnnotationsEnabled element = node != null ? node : process;
        List<Dimension> dimensionList = new DimensionFactoryImpl(this.project).getDimensionsFor(this.type, (ProjectObject)((Object)element), process);
        if (this.dimensions != null) {
            for (Dimension dimension : dimensionList) {
                if (!this.dimensions.isEmpty() && this.isSameDimension(this.dimensions.get(0), dimension)) continue;
                result.add(dimension);
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WidgetDataModelImpl)) {
            return false;
        }
        WidgetDataModelImpl widgetDataModel = (WidgetDataModelImpl)o;
        if (this.activityId != null ? !this.activityId.equals(widgetDataModel.activityId) : widgetDataModel.activityId != null) {
            return false;
        }
        if (!((Object)this.dimensions).equals(widgetDataModel.dimensions)) {
            return false;
        }
        if (this.measurement != null ? !this.measurement.equals(widgetDataModel.measurement) : widgetDataModel.measurement != null) {
            return false;
        }
        if (this.processId != null ? !this.processId.equals(widgetDataModel.processId) : widgetDataModel.processId != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals((Object)widgetDataModel.type) : widgetDataModel.type != null);
    }

    public int hashCode() {
        int result = this.measurement != null ? this.measurement.hashCode() : 0;
        result = 29 * result + (this.activityId != null ? this.activityId.hashCode() : 0);
        result = 29 * result + (this.processId != null ? this.processId.hashCode() : 0);
        result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 29 * result + ((Object)this.dimensions).hashCode();
        return result;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.WIDGET;
    }

    @NotNull
    public WidgetDataModel.Mutable asMutable() {
        return this;
    }

    public boolean isAdvancedWidget() {
        boolean parametric = this.parametricActivity || this.parametricOu || this.parametricProcess;
        boolean ou = this.type.isOuType();
        return parametric || ou;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("WidgetDataModelImpl");
        buf.append("{activityId=").append(this.activityId);
        buf.append(",dimensions=").append(this.dimensions);
        buf.append(",measurement=").append(this.measurement);
        buf.append(",processId=").append(this.processId);
        buf.append(",type=").append(this.type);
        buf.append('}');
        return buf.toString();
    }

    public DrillDown getDrillDown() {
        return this.drillDown;
    }

    public void setDrillDown(DrillDown drillDown) {
        this.drillDown = drillDown;
        if (drillDown != null) {
            this.hasDrillDown = true;
        }
    }

    public boolean hasDrillDown() {
        return this.hasDrillDown;
    }

    public void setHasDrillDown(boolean hasDrillDown) {
        this.hasDrillDown = hasDrillDown;
        if (!hasDrillDown) {
            this.drillDown = null;
        }
    }

    public String getOuName() {
        return this.ouName;
    }

    public void setOuName(String ouName) {
        this.ouName = ouName;
    }

    public void setWidgetValueType(WidgetValueType valueType) {
        this.valueType = valueType;
    }

    public boolean isParametricActivity() {
        return this.parametricActivity;
    }

    public void setParametricActivity(boolean parametricActivity) {
        this.parametricActivity = parametricActivity;
    }

    public boolean isParametricOu() {
        return this.parametricOu;
    }

    public void setParametricOu(boolean parametricOu) {
        this.parametricOu = parametricOu;
    }

    public boolean isParametricProcess() {
        return this.parametricProcess;
    }

    public void setParametricProcess(boolean parametricProcess) {
        this.parametricProcess = parametricProcess;
    }

    public void setProject(Project project) {
        this.project = project;
        if (this.measurement != null) {
            ((MeasurementImpl)this.measurement).setProject(project);
        }
        for (Dimension dimension : this.dimensions) {
            ((DimensionImpl)dimension).setProject(project);
        }
    }

    private boolean isSameDimension(Dimension dimension1, Dimension dimension2) {
        DimensionKind kind2;
        DimensionKind kind1 = dimension1.getKind();
        boolean result = kind1.equals((Object)(kind2 = dimension2.getKind()));
        if (result && kind1.equals((Object)DimensionKind.BUSINESS_DIMENSION)) {
            result = dimension1.getVarId().equals(dimension2.getVarId());
        }
        return result;
    }
}

