/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.MeasurementKind;
import oracle.bpm.dashboard.model.OperationType;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.project.dashboard.MeasurementFactoryImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;

public class MeasurementImpl
implements Measurement {
    private transient String columnName;
    private MeasurementKind kind;
    private transient String name;
    private OperationType operationType;
    private Project project;
    private List<BusinessVariableData.Range> ranges = new ArrayList<BusinessVariableData.Range>();
    private CatalogType type;
    private String varId;

    public MeasurementImpl() {
        this(null);
    }

    public MeasurementImpl(Project project) {
        this.project = project;
    }

    public MeasurementImpl(Project project, String varId, MeasurementKind kind) {
        this(project);
        this.varId = varId;
        this.kind = kind;
        this.name = kind.getString();
        this.operationType = OperationType.SUM;
    }

    public Project getProject() {
        return this.project;
    }

    public String getVariableLabel() {
        return this.project.findDataObject(this.getVarId()).getLabel(this.project.getDefaultLanguage());
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        if (this.columnName == null) {
            this.columnName = new MeasurementFactoryImpl(this.project).obtainColumnName(this);
        }
        return this.columnName;
    }

    public void setKind(MeasurementKind kind) {
        this.kind = kind;
    }

    public void setKind(String kindName) {
        this.kind = MeasurementKind.valueOf((String)kindName);
    }

    public MeasurementKind getKind() {
        return this.kind;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = OperationType.valueOf((String)operationType);
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public List<BusinessVariableData.Range> getRanges() {
        return this.ranges;
    }

    public void setType(CatalogType type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = CatalogType.Default.get((TypeRef)TypeFactory.forName((String)type).get());
    }

    public CatalogType getType() {
        return this.type;
    }

    public void setVarId(String varId) {
        this.varId = varId;
    }

    public String getVarId() {
        return this.varId;
    }

    public void addRange(BusinessVariableData.Range range) {
        this.ranges.add(range);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MeasurementImpl)) {
            return false;
        }
        MeasurementImpl measurement = (MeasurementImpl)o;
        if (this.operationType != null ? !this.operationType.equals((Object)measurement.operationType) : measurement.operationType != null) {
            return false;
        }
        if (!((Object)this.ranges).equals(measurement.ranges)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(measurement.type) : measurement.type != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals((Object)measurement.kind) : measurement.kind != null) {
            return false;
        }
        return this.varId.equals(measurement.varId);
    }

    public int hashCode() {
        int result = this.operationType != null ? this.operationType.hashCode() : 0;
        result = 29 * result + this.varId.hashCode();
        result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 29 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 29 * result + ((Object)this.ranges).hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MeasurementImpl");
        buf.append("{columnName=").append(this.columnName);
        buf.append(",name=").append(this.name);
        buf.append(",ranges=").append(this.ranges);
        buf.append(",kind=").append(this.kind);
        buf.append(",operationType=").append(this.operationType);
        buf.append(",varId=").append(this.varId);
        buf.append(",type=").append(this.type);
        buf.append('}');
        return buf.toString();
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

