/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.MeasurementFactory;
import oracle.bpm.dashboard.model.MeasurementKind;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.project.MeasurementImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.VarUtils;

public class MeasurementFactoryImpl
implements MeasurementFactory {
    private Project project;

    public MeasurementFactoryImpl(Project project) {
        this.project = project;
    }

    public List<Measurement> getMeasurementsFor(WidgetType type, ProjectObject element, Process process) {
        List<Object> result = new ArrayList();
        if (WidgetType.ACTIVITY_WORKLOAD.equals((Object)type)) {
            result = this.getActivityWorkloadMeasurements(element, process);
        } else if (WidgetType.ACTIVITY_PERFORMANCE.equals((Object)type)) {
            result = this.getActivityPerformanceMeasurements(element, process);
        } else if (WidgetType.PROCESS_PERFORMANCE.equals((Object)type)) {
            result = this.getProcessPerformanceMeasurements(process);
        } else if (WidgetType.ALL_ACTIVITIES_WORKLOAD.equals((Object)type)) {
            result = this.getAllActivitiesWorkloadMeasurements(element, process);
        } else if (WidgetType.ALL_ACTIVITIES_PERFORMANCE.equals((Object)type)) {
            result = this.getAllActivitiesPerformanceMeasurements(element, process);
        } else if (type.equals((Object)WidgetType.ALL_OUS_WORKLOAD) || type.equals((Object)WidgetType.OU_WORKLOAD)) {
            result = this.getOuWorkloadMeasurements();
        } else if (WidgetType.ALL_OUS_ACTIVITY_PERFORMANCE.equals((Object)type) || type.equals((Object)WidgetType.OU_ACTIVITY_PERFORMANCE)) {
            result = this.getOuActivityPerformanceMeasurements();
        } else if (type.equals((Object)WidgetType.ALL_OUS_PROCESS_PERFORMANCE) || type.equals((Object)WidgetType.OU_PROCESS_PERFORMANCE)) {
            result = this.getOuProcessPerformanceMeasurements();
        }
        return result;
    }

    public String obtainColumnName(Measurement measurement) {
        String columnName = "";
        if (MeasurementKind.NUMBER_OF_INSTANCES.equals((Object)measurement.getKind())) {
            columnName = "quantity";
        } else if (MeasurementKind.MEAN_TIME.equals((Object)measurement.getKind())) {
            columnName = "avgTimeTask";
        } else if (MeasurementKind.AVG_TIME.equals((Object)measurement.getKind())) {
            columnName = "meanTimeTask";
        } else if (MeasurementKind.BUSINESS_MEASUREMENT.equals((Object)measurement.getKind())) {
            columnName = VarUtils.getExternalVariableDatabaseColumnName(measurement.getVarId());
        } else if (MeasurementKind.TASK_TIME.equals((Object)measurement.getKind())) {
            columnName = "taskTime";
        } else if (MeasurementKind.IDLE_TIME.equals((Object)measurement.getKind())) {
            columnName = "idleTime";
        } else if (MeasurementKind.PROCESS_TIME.equals((Object)measurement.getKind())) {
            columnName = "taskTime";
        }
        return columnName;
    }

    public Measurement getNumberOfInstancesMeasurement() {
        oracle.bpm.project.dashboard.MeasurementImpl numberOfInstances = new oracle.bpm.project.dashboard.MeasurementImpl(this.project, "quantity", MeasurementKind.NUMBER_OF_INSTANCES);
        numberOfInstances.setType(this.obtainType(numberOfInstances));
        return numberOfInstances;
    }

    public Measurement getProcessTimeMeasurement() {
        oracle.bpm.project.dashboard.MeasurementImpl taskTime = new oracle.bpm.project.dashboard.MeasurementImpl(this.project, "processTime", MeasurementKind.PROCESS_TIME);
        taskTime.setType(this.obtainType(taskTime));
        return taskTime;
    }

    public Measurement getTaskTimeMeasurement() {
        oracle.bpm.project.dashboard.MeasurementImpl taskTime = new oracle.bpm.project.dashboard.MeasurementImpl(this.project, "taskTime", MeasurementKind.TASK_TIME);
        taskTime.setType(this.obtainType(taskTime));
        return taskTime;
    }

    public Measurement getIdleTimeMeasurement() {
        oracle.bpm.project.dashboard.MeasurementImpl idleTime = new oracle.bpm.project.dashboard.MeasurementImpl(this.project, "idleTime", MeasurementKind.IDLE_TIME);
        idleTime.setType(this.obtainType(idleTime));
        return idleTime;
    }

    public List<Measurement> getActivityWorkloadMeasurements(ProjectObject projectElement, Process process) {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        result.add(this.getNumberOfInstancesMeasurement());
        result.add(this.getAvgTimeMeasurement());
        result.add(this.getMeanTimeMeasurement());
        result.addAll(this.getBusinessMeasurements(projectElement, process));
        return result;
    }

    public List<Measurement> getAllActivitiesPerformanceMeasurements(ProjectObject element, Process process) {
        return this.getActivityPerformanceMeasurements(element, process);
    }

    public Measurement getMeanTimeMeasurement() {
        oracle.bpm.project.dashboard.MeasurementImpl meanTimeMeasurement = new oracle.bpm.project.dashboard.MeasurementImpl(this.project, "meanTime", MeasurementKind.MEAN_TIME);
        meanTimeMeasurement.setType(this.obtainType(meanTimeMeasurement));
        return meanTimeMeasurement;
    }

    private static Measurement createMeasurement(ProjectDataObject businessDataObject) {
        oracle.bpm.project.dashboard.MeasurementImpl measurement = new oracle.bpm.project.dashboard.MeasurementImpl(businessDataObject.getProject(), businessDataObject.getId(), MeasurementKind.BUSINESS_MEASUREMENT);
        measurement.setType(businessDataObject.getType());
        measurement.setName(businessDataObject.getId());
        return measurement;
    }

    private List<Measurement> getOuProcessPerformanceMeasurements() {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        result.add(this.getProcessTimeMeasurement());
        return result;
    }

    private List<Measurement> getOuActivityPerformanceMeasurements() {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        result.add(this.getTaskTimeMeasurement());
        return result;
    }

    private List<Measurement> getOuWorkloadMeasurements() {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        result.add(this.getNumberOfInstancesMeasurement());
        result.add(this.getAvgTimeMeasurement());
        result.add(this.getMeanTimeMeasurement());
        return result;
    }

    private List<Measurement> getActivityPerformanceMeasurements(ProjectObject projectElement, Process process) {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        result.add(this.getTaskTimeMeasurement());
        result.add(this.getIdleTimeMeasurement());
        result.addAll(this.getBusinessMeasurements(projectElement, process));
        return result;
    }

    private List<Measurement> getAllActivitiesWorkloadMeasurements(ProjectObject element, Process process) {
        return this.getActivityWorkloadMeasurements(element, process);
    }

    private Measurement getAvgTimeMeasurement() {
        oracle.bpm.project.dashboard.MeasurementImpl avgTimeMeasurement = new oracle.bpm.project.dashboard.MeasurementImpl(this.project, "avgTime", MeasurementKind.AVG_TIME);
        avgTimeMeasurement.setType(this.obtainType(avgTimeMeasurement));
        return avgTimeMeasurement;
    }

    private List<Measurement> getBusinessMeasurement(MeasurementImpl measurementMark) {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        Sequence<ProjectDataObject> businessVars = measurementMark.getBusinessIndicators();
        for (ProjectDataObject businessVar : businessVars) {
            this.addBusinessMeasurement(businessVar, result);
        }
        return result;
    }

    private List<Measurement> getBusinessMeasurements(ProjectObject projectElement, Process process) {
        return projectElement instanceof MeasurementImpl ? this.getBusinessMeasurement((MeasurementImpl)projectElement) : this.getProjectBusinessMeasurements(process);
    }

    private List<Measurement> getProcessPerformanceMeasurements(Process process) {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        result.add(this.getProcessTimeMeasurement());
        result.addAll(this.getProjectBusinessMeasurements(process));
        return result;
    }

    private List<Measurement> getProjectBusinessMeasurements(Process process) {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        Collection<ProjectDataObject> projectDataObjects = process.getProject().getProjectDataObjects();
        for (ProjectDataObject projectDataObject : projectDataObjects) {
            this.addBusinessMeasurement(projectDataObject, result);
        }
        return result;
    }

    private void addBusinessMeasurement(ProjectDataObject businessDataObject, List<Measurement> businessMeasurements) {
        if (businessDataObject.getBusinessVariableType().equals((Object)BusinessVariableType.MEASURE) && businessDataObject.getType().isNumber()) {
            Measurement measurement = MeasurementFactoryImpl.createMeasurement(businessDataObject);
            businessMeasurements.add(measurement);
        }
    }

    private CatalogType obtainType(Measurement measurement) {
        CatalogType type = CatalogType.Default.getNone();
        if (MeasurementKind.NUMBER_OF_INSTANCES.equals((Object)measurement.getKind())) {
            type = CatalogType.Default.getDecimal();
        } else if (MeasurementKind.AVG_TIME.equals((Object)measurement.getKind())) {
            type = CatalogType.Default.getDecimal();
        } else if (MeasurementKind.MEAN_TIME.equals((Object)measurement.getKind())) {
            type = CatalogType.Default.getDecimal();
        } else if (MeasurementKind.BUSINESS_MEASUREMENT.equals((Object)measurement.getKind())) {
            type = measurement.getType();
        } else if (MeasurementKind.TASK_TIME.equals((Object)measurement.getKind())) {
            type = CatalogType.Default.getDecimal();
        } else if (MeasurementKind.IDLE_TIME.equals((Object)measurement.getKind())) {
            type = CatalogType.Default.getDecimal();
        } else if (MeasurementKind.PROCESS_TIME.equals((Object)measurement.getKind())) {
            type = CatalogType.Default.getDecimal();
        }
        return type;
    }
}

