/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.DimensionKind;
import oracle.bpm.dashboard.model.DimensionType;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.VarUtils;

public class DimensionImpl
implements Dimension {
    private transient String columnName;
    private transient String desciptionTableName;
    private boolean descriptionAvailableWithoutJoin;
    private transient String descriptionColumnName;
    private DimensionType dimensionType;
    private DimensionKind kind;
    private transient String name;
    private Project project;
    private List<BusinessVariableData.Range> ranges;
    private CatalogType type;
    private String varId;

    public DimensionImpl() {
        this(null);
    }

    public DimensionImpl(Project project) {
        this(project, false);
    }

    public DimensionImpl(Project project, boolean descriptionAvailableWithoutJoin) {
        this.project = project;
        this.ranges = new ArrayList<BusinessVariableData.Range>();
        this.descriptionAvailableWithoutJoin = descriptionAvailableWithoutJoin;
        this.dimensionType = DimensionType.DIMENSION;
    }

    public DimensionImpl(Project project, DimensionKind kind) {
        this(project, kind, false);
    }

    public DimensionImpl(Project project, String varId, DimensionKind kind) {
        this(project, varId, kind, false);
    }

    public DimensionImpl(Project project, DimensionKind kind, boolean descriptionAvailableWithoutJoin) {
        this(project, descriptionAvailableWithoutJoin);
        this.kind = kind;
    }

    public DimensionImpl(Project project, String varId, DimensionKind kind, boolean descriptionAvailableWithoutJoin) {
        this(project, descriptionAvailableWithoutJoin);
        this.varId = varId;
        this.kind = kind;
    }

    public String getColumnName() {
        if (this.columnName == null) {
            this.columnName = this.kind == DimensionKind.BUSINESS_DIMENSION ? VarUtils.getExternalVariableDatabaseColumnName(this.getVarId()) : this.kind.getColumnName();
        }
        return this.columnName;
    }

    public String getDescriptionColumnName() {
        if (this.descriptionColumnName == null && this.kind != DimensionKind.BUSINESS_DIMENSION) {
            this.descriptionColumnName = this.kind.getDescriptionColumnName();
        }
        return this.descriptionColumnName;
    }

    public String getVariableLabel() {
        return this.project.findDataObject(this.getVarId()).getLabel(this.project.getDefaultLanguage());
    }

    public String getVarName() {
        return this.kind.getVarName();
    }

    public String getDescriptionTableName() {
        if (this.desciptionTableName == null && this.kind != DimensionKind.BUSINESS_DIMENSION) {
            this.desciptionTableName = this.kind.getDescriptionTableName();
        }
        return this.desciptionTableName;
    }

    public void setDescriptionAvailableWithoutJoin(boolean descriptionAvailableWithoutJoin) {
        this.descriptionAvailableWithoutJoin = descriptionAvailableWithoutJoin;
    }

    public LocaleStringMap getLocalizedNames(Project project) {
        LocaleStringMap result = this.kind == DimensionKind.BUSINESS_DIMENSION ? project.findDataObject(this.varId).getLabelMap() : this.kind.getMsg().getAllAvailableTranslationsForProjectLanguages();
        return result;
    }

    public void setDimensionType(String dimensionType) {
        this.dimensionType = DimensionType.valueOf((String)dimensionType);
    }

    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public void setKind(String kind) {
        this.kind = DimensionKind.valueOf((String)kind);
    }

    public void setKind(DimensionKind kind) {
        this.kind = kind;
        this.columnName = null;
    }

    public DimensionKind getKind() {
        return this.kind;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        String result = this.kind == DimensionKind.BUSINESS_DIMENSION ? this.varId : this.kind.getString();
        return result;
    }

    public List<BusinessVariableData.Range> getRanges() {
        return this.ranges;
    }

    public void setType(String type) {
        this.type = CatalogType.Default.get((TypeRef)TypeFactory.forName((String)type).get());
    }

    public void setType(CatalogType type) {
        this.type = type;
    }

    public CatalogType getType() {
        return this.type;
    }

    public void setVarId(String varId) {
        this.varId = varId;
    }

    public String getVarId() {
        return this.varId;
    }

    public void addRange(BusinessVariableData.Range range) {
        this.ranges.add(range);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DimensionImpl)) {
            return false;
        }
        DimensionImpl dimension = (DimensionImpl)o;
        if (this.dimensionType != null ? !this.dimensionType.equals((Object)dimension.dimensionType) : dimension.dimensionType != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals((Object)dimension.kind) : dimension.kind != null) {
            return false;
        }
        if (!((Object)this.ranges).equals(dimension.ranges)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(dimension.type) : dimension.type != null) {
            return false;
        }
        return !(this.varId != null ? !this.varId.equals(dimension.varId) : dimension.varId != null);
    }

    public boolean hasDescription() {
        return this.kind.equals((Object)DimensionKind.ACTIVITY) || this.kind.equals((Object)DimensionKind.PARTICIPANT) || this.kind.equals((Object)DimensionKind.ROLE) || this.kind.equals((Object)DimensionKind.PROCESS) || this.kind.equals((Object)DimensionKind.OU);
    }

    public int hashCode() {
        int result = this.dimensionType != null ? this.dimensionType.hashCode() : 0;
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 31 * result + (this.ranges != null ? ((Object)this.ranges).hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.varId != null ? this.varId.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DimensionImpl");
        buf.append("{columnName=").append(this.columnName);
        buf.append(",name=").append(this.name);
        buf.append(",kind=").append(this.kind);
        buf.append(",dimensionType=").append(this.dimensionType);
        buf.append(",ranges=").append(this.ranges);
        buf.append(",varId=").append(this.varId);
        buf.append(",type=").append(this.type);
        buf.append('}');
        return buf.toString();
    }

    public boolean isDescriptionAvailableWithoutJoin() {
        return this.descriptionAvailableWithoutJoin;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

