/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.dashboard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.dashboard.model.Resource;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.util.Locales;
import org.jetbrains.annotations.NotNull;

public class DashboardModelImpl
extends ResourceObjectImpl
implements DashboardModel.Mutable,
ResourceObject {
    private ColorInfo background;
    private int columns = 1;
    private LocaleStringMap description;
    private transient Map localizedDescriptionsTmp;
    private LocaleStringMap localizedTitles;
    private transient Map localizedTitlesTmp;
    private String name;
    private int rows = 1;
    private String title;
    private ColorInfo titleBackground;
    private FontInfo titleFont;
    private ColorInfo titleForeground;
    private List<WidgetModel> widgetList = new ArrayList<WidgetModel>();

    public DashboardModelImpl() {
        this(null);
    }

    public DashboardModelImpl(Project project) {
        super(project);
        this.localizedTitles = LocaleStringMap.create();
        this.description = LocaleStringMap.create();
        this.localizedDescriptionsTmp = new HashMap();
    }

    public static DashboardModel obtainTemplate(DashboardModel dashboardModel, String name) {
        DashboardModelImpl template = new DashboardModelImpl(dashboardModel.getProject());
        template.setBackground(dashboardModel.getBackground());
        template.setTitleBackground(dashboardModel.getTitleBackground());
        template.setTitleForeground(dashboardModel.getTitleForeground());
        template.setTitleFont(dashboardModel.getTitleFont());
        template.setName(name);
        LocaleStringMap localizedTitles = dashboardModel.getLocalizedTitles();
        template.putLocalizedTitles(localizedTitles);
        template.columns = 1;
        template.rows = 1;
        return template;
    }

    public void setBackground(ColorInfo background) {
        this.background = background;
    }

    public ColorInfo getBackground() {
        return this.background;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getRows() {
        return this.rows;
    }

    public LocaleStringMap getLocalizedTitles() {
        return this.localizedTitles;
    }

    public LocaleStringMap getLocalizedDescriptions() {
        return this.description;
    }

    public void setTitle(String title) {
        this.localizedTitles.put(this.project.getDefaultLanguage(), title);
    }

    public void setTitle(String title, Locale locale) {
        this.localizedTitles.put(locale, title);
    }

    public String getTitle() {
        return this.localizedTitles.getString(this.project.getDefaultLanguage());
    }

    public String getTitle(Locale locale) {
        return this.localizedTitles.getString(locale);
    }

    public String getLocalizedDescription(Locale locale) {
        return this.description.getString(locale);
    }

    public LocaleStringMap getDescription() {
        return this.description;
    }

    public DashboardModel createDashboardFromTemplate(WidgetModel widgetModel) {
        DashboardModel dashboardModel = DashboardModelImpl.obtainTemplate((DashboardModel)this, widgetModel.getName() + "DrillDown" + "Dashboard");
        dashboardModel.asMutable().addWidget(widgetModel);
        return dashboardModel;
    }

    public void setDescription(String descriptionText, Locale locale) {
        this.description.put(locale, descriptionText);
    }

    public void setTitleBackground(ColorInfo titleBackground) {
        this.titleBackground = titleBackground;
    }

    public ColorInfo getTitleBackground() {
        return this.titleBackground;
    }

    public void setTitleFont(FontInfo titleFont) {
        this.titleFont = titleFont;
    }

    public FontInfo getTitleFont() {
        return this.titleFont;
    }

    public void setTitleForeground(ColorInfo titleForeground) {
        this.titleForeground = titleForeground;
    }

    public ColorInfo getTitleForeground() {
        return this.titleForeground;
    }

    public void setWidgetList(List<WidgetModel> widgetList) {
        this.widgetList = widgetList;
    }

    public List<WidgetModel> getWidgetList() {
        if (this.widgetList == null) {
            this.widgetList = new ArrayList<WidgetModel>();
        }
        return this.widgetList;
    }

    @NotNull
    public DashboardModel.Mutable asMutable() {
        return this;
    }

    public void addWidget(WidgetModel widget) {
        this.widgetList.add(widget);
    }

    @Override
    public void setId(String id) {
        this.setName(id);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.DASHBOARD;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public Path getPath() {
        return Path.DASHBOARDS.create(this.id);
    }

    public void loadLocalizedTitles() {
        if (this.localizedTitlesTmp != null) {
            for (Locale locale : this.localizedTitlesTmp.keySet()) {
                Resource title = (Resource)this.localizedTitlesTmp.get(locale);
                this.localizedTitles.put(locale, title.getValue());
            }
        }
    }

    public void loadLocalizedDescriptions() {
        if (this.localizedDescriptionsTmp != null) {
            for (Locale locale : this.localizedDescriptionsTmp.keySet()) {
                Resource title = (Resource)this.localizedDescriptionsTmp.get(locale);
                this.description.put(locale, title.getValue());
            }
        }
    }

    public void addLocalizedTitle(Resource title) {
        Locale locale = Locales.valueOf(title.getLanguage());
        if (this.localizedTitlesTmp == null) {
            this.localizedTitlesTmp = new HashMap();
        }
        this.localizedTitlesTmp.put(locale, title);
    }

    public void addLocalizedDescription(Resource title) {
        Locale locale = Locales.valueOf(title.getLanguage());
        if (this.localizedDescriptionsTmp == null) {
            this.localizedDescriptionsTmp = new HashMap();
        }
        this.localizedDescriptionsTmp.put(locale, title);
    }

    public void putLocalizedTitles(LocaleStringMap localizedTitles) {
        this.localizedTitles = localizedTitles;
    }

    public void putLocalizedDescriptions(LocaleStringMap localizedDescriptions) {
        this.description = localizedDescriptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardModelImpl that = (DashboardModelImpl)o;
        if (this.columns != that.columns) {
            return false;
        }
        if (this.rows != that.rows) {
            return false;
        }
        if (this.background != null ? !this.background.equals(that.background) : that.background != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.localizedTitles != null ? !this.localizedTitles.equals(that.localizedTitles) : that.localizedTitles != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.titleBackground != null ? !this.titleBackground.equals(that.titleBackground) : that.titleBackground != null) {
            return false;
        }
        if (this.titleFont != null ? !this.titleFont.equals(that.titleFont) : that.titleFont != null) {
            return false;
        }
        if (this.titleForeground != null ? !this.titleForeground.equals(that.titleForeground) : that.titleForeground != null) {
            return false;
        }
        return !(this.widgetList != null ? !((Object)this.widgetList).equals(that.widgetList) : that.widgetList != null);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public int hashCode() {
        int result = this.background != null ? this.background.hashCode() : 0;
        result = 29 * result + this.columns;
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + this.rows;
        result = 29 * result + (this.titleBackground != null ? this.titleBackground.hashCode() : 0);
        result = 29 * result + (this.titleFont != null ? this.titleFont.hashCode() : 0);
        result = 29 * result + (this.titleForeground != null ? this.titleForeground.hashCode() : 0);
        result = 29 * result + (this.widgetList != null ? ((Object)this.widgetList).hashCode() : 0);
        result = 29 * result + (this.localizedTitles != null ? this.localizedTitles.hashCode() : 0);
        return result;
    }
}

