/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeRef;

public class TypeDependencies {
    private Map<String, Set<String>> reverseDependencies = new HashMap<String, Set<String>>();

    public boolean isEmpty() {
        return this.reverseDependencies.isEmpty();
    }

    public void declare(TypeDescription objectType) {
        String text = objectType.getText();
        Set dependencies = objectType.asObject().getDependencies();
        for (TypeRef dependency : dependencies) {
            if (dependency.get().asObject().isDefault()) continue;
            Set<String> set = this.reverseDependencies.get(dependency.getText());
            if (set == null) {
                set = new HashSet<String>();
                this.reverseDependencies.put(dependency.getText(), set);
            }
            set.add(text);
        }
    }

    public Set<String> resolveTransitive(String type) {
        HashSet<String> result = new HashSet<String>();
        this.resolveTransitive(type, result);
        return result;
    }

    public void resolveTransitive(String type, Set<String> result) {
        result.add(type);
        Set<String> deps = this.reverseDependencies.get(type);
        if (deps != null) {
            for (String dep : deps) {
                boolean added = result.add(dep);
                if (!added) continue;
                this.resolveTransitive(dep, result);
            }
        }
    }

    public String toString() {
        return "TypeDependencies[" + this.reverseDependencies + "]";
    }
}

