/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.cil.CilCompiler;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.SuperType;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.FuegoProcessList;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compiler.CompilationOptions;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.compiler.CompilerExtension;
import oracle.bpm.project.compiler.ProjectCompilationListener;
import oracle.bpm.project.compiler.TypeDependencies;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectCompiler {
    private ProjectCompilationListener broadcaster;
    private CilCompiler catalogCompiler;
    @NotNull
    private final List<ProjectCompilationListener> compilationListeners = new ArrayList<ProjectCompilationListener>();
    @NotNull
    private final List<CompilerExtension<ProjectObject>> extensions = new ArrayList<CompilerExtension<ProjectObject>>();
    @Nullable
    private Map<ProjectObjectType, List<CompilerExtension<ProjectObject>>> extensionsByType;
    private CheckOptions options;
    private final Project project;
    @NotNull
    private final Map<ProjectObjectType, Long> stats = new EnumMap<ProjectObjectType, Long>(ProjectObjectType.class);

    private ProjectCompiler(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Null project");
        }
        this.project = project;
    }

    public static ProjectCompiler create(Project project) {
        return new ProjectCompiler(project);
    }

    public static ProjectCompiler createDefault(Project project) {
        ProjectCompiler compiler = ProjectCompiler.create(project);
        for (Extension<CompilerExtensionMetadata> extension : CompilerExtension.Extensions.ALL) {
            CompilerExtension compilerExtension;
            try {
                compilerExtension = (CompilerExtension)Cast.force(extension.instantiateAs(CompilerExtension.class));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            compiler.addExtension(compilerExtension);
        }
        return compiler;
    }

    public static void initializeProcessComponent(ObjectTypeDescription component, ObjectTypeDescription parent) {
        component.addSuperType(new SuperType(TypeFactory.forName((String)Serializable.class.getName()), 32768L));
        component.setProperty("package", parent.getText());
        component.setProperty("generateStubs", "false");
        component.setProperty("generateBitSets", "false");
        component.setProperty("initAllFields", "true");
    }

    public void addExtension(CompilerExtension<ProjectObject> extension) {
        this.extensionsByType = null;
        this.extensions.add(extension);
        extension.configure(this);
    }

    public void addCompilationListener(ProjectCompilationListener listener) {
        if (this.compilationListeners.contains(listener)) {
            throw new IllegalArgumentException("Listener already added  " + listener);
        }
        this.compilationListeners.add(listener);
    }

    public void compile(ProgressMonitor monitor) {
        this.compile(monitor, new CompilationOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(ProgressMonitor monitor, CompilationOptions options) {
        if (monitor == null) {
            monitor = ProgressMonitor.NULL_INSTANCE;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        monitor.progress(0);
        try {
            CompilationSession session = new CompilationSession();
            session.setOptions(options);
            if (options.isDeploying() && this.getBpmProject().isTemplate()) {
                this.getEventBroadcaster().onError(new ProjectException(this.getProject(), ProjectMsg.CANNOT_DEPLOY_TEMPLATE));
                return;
            }
            currentThread.setContextClassLoader(this.getClass().getClassLoader());
            monitor.progress(1);
            this.compileModels(session, monitor, 1, 30);
            monitor.progress(30);
            this.compileCatalog(monitor, options, session);
            monitor.progress(70);
            SimulationsContainer simulationsContainer = this.getBpmProject().getSimulations();
            if (simulationsContainer != null) {
                for (ProjectSimulation simulation : simulationsContainer.getProjectSimulations()) {
                    this.compileProjectObject(simulation, session, monitor);
                }
            }
            this.compileOrganization(session, monitor);
            ActivityGuide activityGuide = this.project.getActivityGuide();
            if (activityGuide != null) {
                this.compileProjectObject(activityGuide, options);
            }
            monitor.progress(80);
            this.compileProjectObject(this.getBpmProject(), session, monitor);
            this.getBpmProject().getProjectConfigurationManager();
        }
        finally {
            currentThread.setContextClassLoader(oldClassLoader);
        }
        monitor.progress(100);
    }

    public CilCompiler getCatalogCompiler() {
        return this.catalogCompiler;
    }

    public CheckOptions getCheckOptions() {
        if (this.options == null) {
            this.options = new CheckOptions();
        }
        return this.options;
    }

    public Project getProject() {
        return this.project;
    }

    public FuegoProject getBpmProject() {
        return (FuegoProject)this.getProject();
    }

    public void setCatalogCompiler(CilCompiler catalogCompiler) {
        this.catalogCompiler = catalogCompiler;
    }

    public void setOptions(CheckOptions options) {
        this.options = options;
    }

    public void compileProjectObject(ProjectObject projectObject, CompilationOptions options) {
        CompilationSession session = new CompilationSession();
        session.setOptions(options);
        this.compileProjectObject(projectObject, session, null);
    }

    protected void compileModels(CompilationSession session, ProgressMonitor monitor, int progressStart, int progressEnd) {
        FuegoProcessList allProcesses = this.getBpmProject().getAllProcesses();
        int length = allProcesses.size();
        if (length != 0) {
            Process[] models = allProcesses.toArray(new Process[allProcesses.size()]);
            int processNumber = 0;
            int step = (progressEnd - progressStart) / length;
            Process model = this.getBpmProject().getProjectModel();
            this.compileProjectObject(model, session, monitor);
            for (Process process : models) {
                if (this.isInterrupted()) break;
                ++processNumber;
                ProjectCompiler.updateMonitor(monitor, process);
                this.compileProjectObject(process, session, monitor);
                SimulationsContainer simulationsContainer = this.getProject().getSimulations();
                if (simulationsContainer != null) {
                    for (ModelSimulation simulation : simulationsContainer.getModelSimulationsByProcess(process)) {
                        this.compileProjectObject(simulation, session, monitor);
                    }
                }
                if (monitor == null) continue;
                monitor.progress(progressStart + step * processNumber);
            }
        }
    }

    protected void compileCatalog(TypeRef root, CompilationSession session, ProgressMonitor monitor) {
        ObjectTypeDescription objectType = root.get().asObject();
        boolean isFuegoObject = objectType.isBpmObject();
        if (!objectType.isInnerType()) {
            CatalogObject projectType = CatalogObjectImpl.create(this.project, (TypeRef)objectType);
            this.compileProjectObject(projectType, session, monitor);
        }
        if (!objectType.isDefault() && (isFuegoObject || objectType.isModule() || objectType.isIntrospectedObject() && objectType.getInnerTypeCount() != 0)) {
            int icount = objectType.getInnerTypeCount();
            for (int i = 0; i < icount && !this.isInterrupted(); ++i) {
                ObjectTypeDescription typeDescription = objectType.getInnerType(i);
                if (objectType != typeDescription) {
                    this.compileCatalog((TypeRef)typeDescription, session, monitor);
                    continue;
                }
                ProjectCompilationListener listener = this.getEventBroadcaster();
                CatalogObject projectType = CatalogObjectImpl.create(this.project, (TypeRef)objectType);
                listener.onError(new ProjectException(projectType, ProjectMsg.RECURSIVE_PROBLEM_WITH_TYPE(objectType.getName())));
            }
        }
    }

    ProjectCompilationListener getEventBroadcaster() {
        ProjectCompilationListener result;
        if (this.compilationListeners.size() == 1) {
            result = this.compilationListeners.get(0);
        } else {
            if (this.broadcaster == null) {
                this.broadcaster = new DefaultBroadcaster();
            }
            result = this.broadcaster;
        }
        return result;
    }

    ObjectTypeDescription addComponentToModule(String moduleName, ObjectTypeDescription component) {
        String[] path;
        MutableComponentCatalog catalog = (MutableComponentCatalog)this.getProject().getComponentCatalog();
        ObjectTypeDescription parent = catalog.getRoot();
        for (String module : path = moduleName.split("\\.")) {
            TypeRef current = parent.findInnerType(module);
            if (current == null) {
                ObjectTypeDescription tree = new ObjectTypeDescription(module);
                tree.setModifiers(tree.getModifiers() | 0x100000000L | 0x2000000L);
                ProjectCompiler.addComponentToModule(parent, tree, catalog);
                current = tree;
            }
            parent = current.get().asObject();
        }
        try {
            assert (catalog.find(moduleName) != null) : "Parent should have been found";
        }
        catch (AmbiguousTypeNameException e) {
            throw new RuntimeExceptionShell(e);
        }
        component.setParent((TypeRef)parent);
        component.setCatalog((ComponentCatalog)catalog);
        try {
            String componentName = parent.getText() + '.' + component.getName();
            TypeRef type = catalog.find(componentName);
            if (type != null) {
                parent.get().asObject().removeInnerType(type);
                catalog.remove(componentName);
                assert (catalog.find(componentName) == null) : "the project component '" + componentName + "' shouldn't be in the catalog";
            }
        }
        catch (AmbiguousTypeNameException e) {
            throw new RuntimeExceptionShell(e);
        }
        catch (TypeCatalogException e) {
            throw new RuntimeExceptionShell(e);
        }
        ProjectCompiler.initializeProcessComponent(component, parent);
        ProjectCompiler.addComponentToModule(parent, component, catalog);
        return component;
    }

    private static void addComponentToModule(ObjectTypeDescription module, ObjectTypeDescription component, MutableComponentCatalog catalog) {
        assert (component.isSynthesized()) : component;
        module.addInnerType((TypeRef)component);
        try {
            catalog.add(component);
        }
        catch (TypeCatalogException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    private static void updateMonitor(ProgressMonitor monitor, Process process) {
        if (monitor != null) {
            LocaleStringMap labelMap = process.getLabelMap();
            String label = labelMap.getString();
            monitor.info(ProjectMsg.CHECKING_PROCESS(label));
        }
    }

    @NotNull
    private static List<CompilerExtension<ProjectObject>> getExtensions(Map<ProjectObjectType, List<CompilerExtension<ProjectObject>>> result, ProjectObjectType type) {
        List<CompilerExtension<ProjectObject>> all = result.get((Object)type);
        if (all == null) {
            all = new ArrayList<CompilerExtension<ProjectObject>>();
            result.put(type, all);
        }
        return all;
    }

    private void compileOrganization(CompilationSession session, ProgressMonitor monitor) {
        Organization org = this.getBpmProject().getOrganization();
        this.compileOrganization(session, monitor, org);
    }

    private void compileOrganization(CompilationSession session, ProgressMonitor monitor, ProjectObjectContainer container) {
        if (container != null) {
            for (ProjectObject projectObject : container.getChildren()) {
                if (container instanceof ResourceObject) {
                    this.compileProjectObject(projectObject, session, monitor);
                    continue;
                }
                if (!(projectObject instanceof ProjectObjectContainer)) continue;
                this.compileOrganization(session, monitor, (ProjectObjectContainer)projectObject);
            }
        }
    }

    private void compileProjectObject(ProjectObject projectObject, CompilationSession session, ProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        if (monitor != null) {
            monitor.info(ProjectMsg.COMPILING(projectObject.getId()));
        }
        ProjectCompilationListener listener = this.getEventBroadcaster();
        listener.onCheckStarted(projectObject);
        ProjectObjectType objectType = projectObject.getProjectObjectType();
        List<CompilerExtension<ProjectObject>> compilers = this.getExtensionsByType().get((Object)objectType);
        if (compilers != null) {
            for (CompilerExtension<ProjectObject> compiler : compilers) {
                try {
                    if (!compiler.supports(projectObject)) continue;
                    compiler.compile(projectObject, session);
                }
                catch (ProjectException e) {
                    listener.onError(e);
                }
                catch (Throwable unexpected) {
                    unexpected.printStackTrace();
                    listener.onError(ProjectException.wrap(projectObject, unexpected));
                }
            }
        }
        listener.onCheckFinished(projectObject);
        long end = System.currentTimeMillis();
        Long time = this.stats.get((Object)projectObject.getProjectObjectType());
        if (time == null) {
            time = 0L;
        }
        time = time + (end - start);
        this.stats.put(projectObject.getProjectObjectType(), time);
    }

    @NotNull
    private Map<ProjectObjectType, List<CompilerExtension<ProjectObject>>> getExtensionsByType() {
        Map<ProjectObjectType, List<CompilerExtension<ProjectObject>>> result = this.extensionsByType;
        if (result == null) {
            this.extensionsByType = result = this.buildExtensionsByType();
        }
        return result;
    }

    @NotNull
    private Map<ProjectObjectType, List<CompilerExtension<ProjectObject>>> buildExtensionsByType() {
        EnumMap<ProjectObjectType, List<CompilerExtension<ProjectObject>>> result = new EnumMap<ProjectObjectType, List<CompilerExtension<ProjectObject>>>(ProjectObjectType.class);
        for (CompilerExtension<ProjectObject> extension : this.extensions) {
            for (ProjectObjectType type : extension.getSupportedTypes()) {
                ProjectCompiler.getExtensions(result, type).add(extension);
            }
        }
        return result;
    }

    private void compileCatalog(ProgressMonitor monitor, CompilationOptions options, CompilationSession session) {
        if (monitor != null) {
            monitor.info(ProjectMsg.COMPILING_XOBJECTS);
        }
        CilCompiler compiler = this.getCatalogCompiler();
        assert (this.catalogCompiler != null) : "Must set a FuegoCompiler first";
        compiler.reset();
        FuegoProject fuegoProject = this.getBpmProject();
        MutableComponentCatalog catalog = fuegoProject.getComponentCatalog();
        TypeDependencies dependencies = options.getLastBuildDependencies();
        if (options.isFullBuild() || dependencies.isEmpty()) {
            options.setLastBuildDependencies(null);
            this.compileCatalog((TypeRef)catalog.getRoot(), session, monitor);
        } else {
            Set<String> affectedTypes = options.getAffectedTypes();
            HashSet<String> transitiveDeps = new HashSet<String>();
            for (String affectedType : affectedTypes) {
                dependencies.resolveTransitive(affectedType, transitiveDeps);
            }
            transitiveDeps.removeAll(options.getRemovedTypes());
            LinkedHashSet<TypeRef> types = new LinkedHashSet<TypeRef>();
            for (String dep : transitiveDeps) {
                try {
                    TypeRef type = catalog.find(dep);
                    if (type == null) continue;
                    types.add(type.get().isInnerType() ? type.get().getParentRef() : type);
                }
                catch (AmbiguousTypeNameException e) {
                    e.printStackTrace();
                }
            }
            for (TypeRef type : types) {
                CatalogObject projectType = CatalogObjectImpl.create(type);
                this.compileProjectObject(projectType, session, monitor);
            }
        }
        if (monitor != null) {
            monitor.info(ProjectMsg.CHECKING_JCLS);
        }
    }

    private boolean isInterrupted() {
        ProjectCompilationListener broadcaster = this.getEventBroadcaster();
        return broadcaster.onInterruptionCheck();
    }

    private final class DefaultBroadcaster
    implements ProjectCompilationListener {
        private DefaultBroadcaster() {
        }

        @Override
        public void onError(ProjectException exception) {
            for (ProjectCompilationListener listener : ProjectCompiler.this.compilationListeners) {
                listener.onError(exception);
            }
        }

        @Override
        public void onWarning(ProjectException exception) {
            for (ProjectCompilationListener listener : ProjectCompiler.this.compilationListeners) {
                listener.onWarning(exception);
            }
        }

        @Override
        public void onInfo(ProjectException exception) {
            for (ProjectCompilationListener listener : ProjectCompiler.this.compilationListeners) {
                listener.onInfo(exception);
            }
        }

        @Override
        public void onCheckFinished(ProjectObject projectObject) {
            for (ProjectCompilationListener listener : ProjectCompiler.this.compilationListeners) {
                listener.onCheckFinished(projectObject);
            }
        }

        @Override
        public void onCheckStarted(ProjectObject projectObject) {
            for (ProjectCompilationListener listener : ProjectCompiler.this.compilationListeners) {
                listener.onCheckStarted(projectObject);
            }
        }

        @Override
        public boolean onInterruptionCheck() {
            for (ProjectCompilationListener listener : ProjectCompiler.this.compilationListeners) {
                if (!listener.onInterruptionCheck()) continue;
                return true;
            }
            return false;
        }
    }
}

