/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compiler;

import oracle.bpm.cil.CilCompiler;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.compiler.ModelCompiler;
import oracle.bpm.project.compiler.ProjectCompiler;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;

@CompilerExtensionMetadata
public class ProcessCompiler
extends ModelCompiler {
    @Override
    public boolean supports(Process object) {
        return true;
    }

    @Override
    public void compile(Process process, CompilationSession session) throws ProjectException {
        ProjectCompiler projectCompiler = this.getProjectCompiler();
        Project project = process.getProject();
        CheckOptions checkOptions = this.createCheckOptions();
        checkOptions.setDeploying(session.getOptions().isDeploying());
        checkOptions.setIgnoreScriptError(true);
        CilCompiler cilCompiler = projectCompiler.getCatalogCompiler();
        assert (cilCompiler != null) : "Must set a FuegoCompiler first";
        cilCompiler.reset();
        ProcessChecker checker = new ProcessChecker(process, checkOptions);
        checker.setCompiler(cilCompiler);
        ModelCompiler.ProjectCompilerMessageListener listener = new ModelCompiler.ProjectCompilerMessageListener();
        checker.setListener((ProjectMessageListener)listener);
        checker.check();
    }

    protected CheckOptions createCheckOptions() {
        return this.getProjectCompiler().getCheckOptions();
    }
}

