/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.builder;

import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.builder.MethodBuilder;
import oracle.bpm.type.TypeRef;

public class JavaMethodBuilder
extends MethodBuilder {
    public JavaMethodBuilder() {
        super(JAVA_TOKENS);
    }

    @Override
    public String getLanguage() {
        return "Java";
    }

    @Override
    public MethodBuilder createMethodCall() {
        return new JavaMethodBuilder();
    }

    @Override
    protected void generateDeclaration(IndentedPrintWriter pw, String var, TypeDescription type) {
        TypeRenderer renderer = TypeRenderer.getInstance((String)"Java");
        assert (renderer != null) : "Could not load type renderer for 'Java'";
        pw.println(renderer.render((TypeRef)type) + " " + var + this.getStatementSeparator());
    }

    @Override
    protected void generateInArg(IndentedPrintWriter pw, String arg, String text) {
        pw.print(arg);
        if (text != null) {
            pw.print(" : ");
            pw.print(text);
        }
    }

    @Override
    protected void generateInArgsClose(IndentedPrintWriter pw) {
        if (this.isDisplay()) {
            pw.dedent();
        }
    }

    @Override
    protected void generateInArgsOpen(IndentedPrintWriter pw) {
        if (this.isDisplay()) {
            pw.println(",");
            pw.indent();
        } else if (!this.isInput()) {
            pw.print("(");
        }
    }

    @Override
    protected void generateInitialize(IndentedPrintWriter pw, String var, String value) {
        pw.println(var + " = " + value + this.getStatementSeparator());
    }

    @Override
    protected void generateMethodCall(IndentedPrintWriter pw, String method, String instance) {
        assert (method != null) : "Method cannot be null for method calls";
        assert (instance != null) : "Instance cannot be null for method calls";
        if (this.isDisplay()) {
            pw.print(method);
            pw.print("(");
            pw.print("(String) ");
            pw.print("(");
            pw.print(instance);
            pw.print(")");
        } else if (this.isInput()) {
            pw.print(method);
            pw.print("(");
            pw.print(instance);
            pw.print(',');
        } else {
            pw.print(instance);
            pw.print(".");
            pw.print(method);
        }
    }

    @Override
    protected void generateOutArg(IndentedPrintWriter pw, String argument, String variable) {
        pw.print("out ");
        pw.print(argument);
        pw.print(" : ");
        pw.print(variable);
    }

    @Override
    protected void generateOutArgsClose(IndentedPrintWriter pw) {
        pw.print(")");
    }

    @Override
    protected void generateOutArgsOpen(IndentedPrintWriter pw) {
        if (!this.getInArgs().isEmpty() && !this.getOutArgs().isEmpty()) {
            pw.print(", ");
        }
    }

    @Override
    protected void generateRelayArgsClose(IndentedPrintWriter pw) {
        pw.print(")");
    }

    @Override
    protected void generateRelayArgsOpen(IndentedPrintWriter pw) {
        pw.print("(");
    }

    @Override
    protected void generateRelayCall(IndentedPrintWriter pw) {
        pw.println();
        pw.print("relay to " + this.getRelayTarget());
    }

    @Override
    protected void generateReturn(IndentedPrintWriter pw) {
        String returnStmt = this.getReturnStmt();
        if (this.hasRelay() && returnStmt != null) {
            throw new IllegalStateException("Cannot have a relay to with return");
        }
        if (returnStmt != null) {
            pw.print("return " + returnStmt);
            pw.print(this.getStatementSeparator());
        }
    }
}

