/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activityguide;

import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.activityguide.MilestoneActivityImpl;
import oracle.bpm.project.activityguide.TranslatableValueImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.activityguide.ActivityRef;
import oracle.bpm.project.model.activityguide.DisplayMode;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.activityguide.TranslatableValue;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.project.model.exception.ProjectException;

public class MilestoneImpl
extends ProjectObjectContainerImpl
implements Milestone {
    private DisplayMode displayMode = DisplayMode.DEFAULT;
    private String iconLocation;
    private ProjectObjectContainer parent;
    private int tasksRemaining;
    private TranslatableValue translatableDescription = new TranslatableValueImpl(TranslationType.STATIC, "");
    private TranslatableValue translatableTitle = new TranslatableValueImpl(TranslationType.STATIC, "");

    public MilestoneImpl(ProjectObjectContainer parent, String id) {
        super(parent.getProject());
        this.setId(id);
        this.parent = parent;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.parent;
    }

    @Override
    public MilestoneActivity createMilestoneActivity(ActivityRef activityRef) throws ProjectException {
        return new MilestoneActivityImpl(this, activityRef);
    }

    @Override
    public void setTitle(String title) {
        this.translatableTitle = new TranslatableValueImpl(TranslationType.STATIC, title);
        this.events().objectChanged();
    }

    @Override
    public void setTitle(TranslatableValue translatableTitle) {
        this.translatableTitle = translatableTitle;
        this.events().objectChanged();
    }

    @Override
    public void setDescription(String description) {
        this.translatableDescription = new TranslatableValueImpl(TranslationType.STATIC, description);
        this.events().objectChanged();
    }

    @Override
    public void setDescription(TranslatableValue translatableDescription) {
        this.translatableDescription = translatableDescription;
        this.events().objectChanged();
    }

    @Override
    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.events().objectChanged();
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public void setTasksRemaining(int tasksRemaining) {
        this.tasksRemaining = tasksRemaining;
        this.events().objectChanged();
    }

    @Override
    public int getTasksRemaining() {
        return this.tasksRemaining;
    }

    @Override
    public void setIconLocation(String iconLocation) {
        this.iconLocation = iconLocation;
        this.events().objectChanged();
    }

    @Override
    public String getIconLocation() {
        return this.iconLocation;
    }

    @Override
    public void addMilestoneActivity(MilestoneActivity milestoneActivity) throws ProjectException {
        this.addChild(milestoneActivity);
    }

    @Override
    public void removeMilestoneActivity(MilestoneActivity milestoneActivity) throws ProjectException {
        this.removeChild(milestoneActivity);
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public TranslatableValue getTranslatableDescription() {
        return this.translatableDescription;
    }

    @Override
    public TranslatableValue getTranslatableTitle() {
        return this.translatableTitle;
    }

    @Override
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MILESTONE;
    }
}

