/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activityguide;

import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.activityguide.ActivityRef;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class ActivityRefImpl
extends ProjectObjectImpl
implements ActivityRef {
    private String activityId;
    private String processId;

    public ActivityRefImpl(@NotNull Activity activity) {
        this(activity.getProject(), activity.getProcess().getId(), activity.getId());
    }

    public ActivityRefImpl(@NotNull Project project, @NotNull String processId, @NotNull String activityId) {
        super(project);
        this.setId(activityId);
        this.activityId = activityId;
        this.processId = processId;
    }

    @Override
    public Process getProcess() {
        Project project = this.getProject();
        if (project != null) {
            return project.findProcess(this.processId);
        }
        return null;
    }

    @Override
    public Activity getActivity() {
        if (this.getProcess() != null) {
            return this.getProcess().findDescendant(Activity.class, this.activityId);
        }
        return null;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }
}

