/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activities;

import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;

public class UnlimitedConcurrentExecutionsFeature
extends FeatureSet {
    private MaxInstances maxInstances = MaxInstances.create();
    private UnlimitedConcurrentExcecution unlimitedConcurrentExcecution;

    private UnlimitedConcurrentExecutionsFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
        this.addFeature(this.maxInstances);
        this.unlimitedConcurrentExcecution = UnlimitedConcurrentExcecution.create();
        this.addFeature(this.unlimitedConcurrentExcecution);
    }

    public static UnlimitedConcurrentExecutionsFeature create() {
        return new UnlimitedConcurrentExecutionsFeature("UnlimitedConcurrentExecutions", ProjectModelMsg.TARGET_FOR_NON_CREATED_INSTANCES, ProjectModelMsg.TARGET_FOR_NON_CREATED_INST_DESCRIP);
    }

    public MaxInstances getMaxInstances() {
        return this.maxInstances;
    }

    public UnlimitedConcurrentExcecution getUnlimitedCopies() {
        return this.unlimitedConcurrentExcecution;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    public static class UnlimitedConcurrentExcecution
    extends BooleanFeature {
        private static final String UNLIMITED_COPIES = "unlimitedCopies";

        private UnlimitedConcurrentExcecution(String featureName, Msg label, Msg description, boolean value) {
            super(featureName, label, description, value);
        }

        public static UnlimitedConcurrentExcecution create() {
            return new UnlimitedConcurrentExcecution(UNLIMITED_COPIES, ProjectModelMsg.MAX_CONCURRENT_EXECUTIONS, ProjectModelMsg.MAX_CONCURRENT_EXCECUTION_DSC, true);
        }
    }

    public static class MaxInstances
    extends IntFeature {
        private static final String MAX_INSTANCES = "maxInstances";

        private MaxInstances(String featureName, Msg label, Msg description, int value) {
            super(featureName, label, description, value);
            this.setMaxValue(1000);
            this.setMinValue(1);
            this.setValue(100);
        }

        public static MaxInstances create() {
            return new MaxInstances(MAX_INSTANCES, null, null, 0);
        }
    }
}

