/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activities;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.project.model.features.ConversationFeature;
import oracle.bpm.project.model.features.ErrorEventDefinitionFeature;
import oracle.bpm.project.model.features.ExceptionTransitionFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.IncomingDataAssociationFeature;
import oracle.bpm.project.model.features.OutgoingDataAssociationFeature;
import oracle.bpm.project.model.features.SignalEventDefinitionFeature;
import oracle.bpm.project.model.features.TimerFeature;
import oracle.bpm.project.model.processes.ActivityExpressionFeature;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;

public class FeaturesByEventTrigger {
    public static Features get(Event e, EventTriggerType trigger) {
        HashMap<Class, Feature> result = new HashMap<Class, Feature>();
        switch (trigger) {
            case CANCEL: {
                break;
            }
            case COMPENSATION: {
                break;
            }
            case CONDITIONAL: {
                break;
            }
            case ERROR: {
                FeaturesByEventTrigger.addTo(result, ErrorEventDefinitionFeature.create());
                FeaturesByEventTrigger.addTo(result, ExceptionTransitionFeature.create());
                if (e.isCatchEvent()) {
                    FeaturesByEventTrigger.addTo(result, OutgoingDataAssociationFeature.create(e));
                }
                if (!e.isThrowEvent()) break;
                FeaturesByEventTrigger.addTo(result, IncomingDataAssociationFeature.create(e));
                break;
            }
            case ESCALATION: {
                break;
            }
            case LINK: {
                FeaturesByEventTrigger.addTo(result, NodeAssociationFeature.create(e));
                break;
            }
            case MESSAGE: {
                FeaturesByEventTrigger.addTo(result, ConversationFeature.create(e.getProject()));
                FeaturesByEventTrigger.addTo(result, ErrorEventDefinitionFeature.create());
                if (e.isCatchEvent()) {
                    FeaturesByEventTrigger.addTo(result, OutgoingDataAssociationFeature.create(e));
                    break;
                }
                FeaturesByEventTrigger.addTo(result, IncomingDataAssociationFeature.create(e));
                break;
            }
            case MULTIPLE: {
                break;
            }
            case NONE: {
                if (e.isCatchEvent()) {
                    FeaturesByEventTrigger.addTo(result, OutgoingDataAssociationFeature.create(e));
                    break;
                }
                FeaturesByEventTrigger.addTo(result, IncomingDataAssociationFeature.create(e));
                break;
            }
            case SIGNAL: {
                FeaturesByEventTrigger.addTo(result, SignalEventDefinitionFeature.create());
                FeaturesByEventTrigger.addTo(result, ActivityExpressionFeature.create());
                if (e.isCatchEvent()) {
                    FeaturesByEventTrigger.addTo(result, OutgoingDataAssociationFeature.create(e));
                    break;
                }
                FeaturesByEventTrigger.addTo(result, IncomingDataAssociationFeature.create(e));
                break;
            }
            case TERMINATE: {
                break;
            }
            case TIMER: {
                FeaturesByEventTrigger.addTo(result, new TimerFeature());
            }
        }
        return Features.create(result);
    }

    private static void addTo(Map<Class, Feature> result, Feature feature) {
        result.put(feature.getClass(), feature);
    }
}

