/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeHolder;
import oracle.bpm.type.TypeRef;

public class TypeHolderImpl
implements TypeHolder {
    private TypeHolder holder;
    private MethodTypeDescription method;
    private String name;
    private TypeRef ref;

    private TypeHolderImpl(Argument arg) {
        this.holder = arg;
    }

    private TypeHolderImpl(MethodTypeDescription mtd) {
        this.method = mtd;
    }

    private TypeHolderImpl(String name, TypeRef ref) {
        this.ref = ref;
        this.name = name;
    }

    public static TypeHolder create(Argument arg) {
        return new TypeHolderImpl(arg);
    }

    public static TypeHolder create(MethodTypeDescription mtd) {
        return new TypeHolderImpl(mtd);
    }

    public static TypeHolder create(String name, TypeRef type) {
        return new TypeHolderImpl(name, type);
    }

    public void setName(String name) {
        if (this.holder != null) {
            this.holder.setName(name);
        } else if (this.method != null) {
            this.method.setName(name);
        } else {
            this.name = name;
        }
    }

    public String getName() {
        if (this.holder != null) {
            return this.holder.getName();
        }
        if (this.method != null) {
            return this.method.getName();
        }
        return this.name;
    }

    public void setType(TypeRef ref) {
        if (this.holder != null) {
            this.holder.setType(ref);
        } else if (this.method != null) {
            this.method.setResultType(ref);
        } else {
            this.ref = ref;
        }
    }

    public TypeDescription getType() {
        if (this.holder != null) {
            return this.holder.getType();
        }
        if (this.method != null) {
            return this.method.getResultType();
        }
        return this.ref.get();
    }

    public Argument getArgument() {
        return (Argument)this.holder;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TypeHolderImpl)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TypeHolderImpl h1 = (TypeHolderImpl)obj;
        boolean nameIsEqual = this.getName().equals(h1.getName());
        boolean typeIsEqual = this.getType().equals(h1.getType());
        return typeIsEqual && nameIsEqual;
    }

    public int hashCode() {
        return (this.getName() != null ? this.getName().hashCode() : 0) ^ (this.getType() != null ? this.getType().hashCode() : 0);
    }

    public String toString() {
        return this.getName();
    }
}

